/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.parser.MarkdownParser;
import org.intellij.plugins.markdown.lang.parser.MarkdownDefaultFlavour;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\u001a\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownParserManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "lastParsingResult", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/ref/SoftReference;", "Lorg/intellij/plugins/markdown/lang/parser/MarkdownParserManager$ParsingResult;", "parse", "Lorg/intellij/markdown/ast/ASTNode;", "buffer", "", "flavour", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "performParsing", "dispose", "", "ParsingResult", "Companion", "intellij.markdown"})
public final class MarkdownParserManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<SoftReference<ParsingResult>> lastParsingResult = new AtomicReference();
    @JvmField
    @NotNull
    public static final Key<MarkdownFlavourDescriptor> FLAVOUR_DESCRIPTION;
    @JvmField
    @NotNull
    public static final MarkdownFlavourDescriptor FLAVOUR;

    @JvmOverloads
    @NotNull
    public final ASTNode parse(@NotNull CharSequence buffer, @NotNull MarkdownFlavourDescriptor flavour) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
        StringUtil.BombedCharSequence wrappedBuffer2 = new StringUtil.BombedCharSequence(buffer){

            protected void checkCanceled() {
                ProgressManager.checkCanceled();
            }
        };
        return this.performParsing((CharSequence)wrappedBuffer2, flavour);
    }

    public static /* synthetic */ ASTNode parse$default(MarkdownParserManager markdownParserManager, CharSequence charSequence, MarkdownFlavourDescriptor markdownFlavourDescriptor, int n, Object object) {
        if ((n & 2) != 0) {
            markdownFlavourDescriptor = FLAVOUR;
        }
        return markdownParserManager.parse(charSequence, markdownFlavourDescriptor);
    }

    private final ASTNode performParsing(CharSequence buffer, MarkdownFlavourDescriptor flavour) {
        ParsingResult info;
        SoftReference<ParsingResult> softReference = this.lastParsingResult.get();
        ParsingResult parsingResult = info = softReference != null ? softReference.get() : null;
        if (info != null && info.getBufferHash() == buffer.hashCode() && Intrinsics.areEqual((Object)info.getBuffer(), (Object)buffer)) {
            return info.getTree();
        }
        ASTNode parseResult = new MarkdownParser(flavour).parse(MarkdownElementTypes.MARKDOWN_FILE, ((Object)buffer).toString(), false);
        this.lastParsingResult.set(new SoftReference<ParsingResult>(new ParsingResult(buffer, parseResult, 0, 4, null)));
        return parseResult;
    }

    static /* synthetic */ ASTNode performParsing$default(MarkdownParserManager markdownParserManager, CharSequence charSequence, MarkdownFlavourDescriptor markdownFlavourDescriptor, int n, Object object) {
        if ((n & 2) != 0) {
            markdownFlavourDescriptor = FLAVOUR;
        }
        return markdownParserManager.performParsing(charSequence, markdownFlavourDescriptor);
    }

    public void dispose() {
        this.lastParsingResult.set(null);
    }

    @JvmOverloads
    @NotNull
    public final ASTNode parse(@NotNull CharSequence buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        return MarkdownParserManager.parse$default(this, buffer, null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final MarkdownParserManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ASTNode parseContent(@NotNull CharSequence buffer, @NotNull MarkdownFlavourDescriptor flavour) {
        return Companion.parseContent(buffer, flavour);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ASTNode parseContent(@NotNull CharSequence buffer) {
        return Companion.parseContent(buffer);
    }

    static {
        Key key = Key.create((String)"Markdown.Flavour");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        FLAVOUR_DESCRIPTION = key;
        FLAVOUR = new MarkdownDefaultFlavour();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0007J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0006H\u0007R)\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003R\u0010\u0010\n\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownParserManager$Companion;", "", "<init>", "()V", "FLAVOUR_DESCRIPTION", "Lcom/intellij/openapi/util/Key;", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getFLAVOUR_DESCRIPTION$annotations", "FLAVOUR", "getInstance", "Lorg/intellij/plugins/markdown/lang/parser/MarkdownParserManager;", "parseContent", "Lorg/intellij/markdown/ast/ASTNode;", "buffer", "", "flavour", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nMarkdownParserManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownParserManager.kt\norg/intellij/plugins/markdown/lang/parser/MarkdownParserManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,75:1\n42#2,3:76\n*S KotlinDebug\n*F\n+ 1 MarkdownParserManager.kt\norg/intellij/plugins/markdown/lang/parser/MarkdownParserManager$Companion\n*L\n65#1:76,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use MarkdownFile.getFlavour() instead")
        public static /* synthetic */ void getFLAVOUR_DESCRIPTION$annotations() {
        }

        @JvmStatic
        @NotNull
        public final MarkdownParserManager getInstance() {
            boolean $i$f$service = false;
            Class<MarkdownParserManager> serviceClass$iv = MarkdownParserManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (MarkdownParserManager)object;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ASTNode parseContent(@NotNull CharSequence buffer, @NotNull MarkdownFlavourDescriptor flavour) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)flavour, (String)"flavour");
            return this.getInstance().parse(buffer, flavour);
        }

        public static /* synthetic */ ASTNode parseContent$default(Companion companion, CharSequence charSequence, MarkdownFlavourDescriptor markdownFlavourDescriptor, int n, Object object) {
            if ((n & 2) != 0) {
                markdownFlavourDescriptor = FLAVOUR;
            }
            return companion.parseContent(charSequence, markdownFlavourDescriptor);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ASTNode parseContent(@NotNull CharSequence buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            return org.intellij.plugins.markdown.lang.parser.MarkdownParserManager$Companion.parseContent$default(this, buffer, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/MarkdownParserManager$ParsingResult;", "", "buffer", "", "tree", "Lorg/intellij/markdown/ast/ASTNode;", "bufferHash", "", "<init>", "(Ljava/lang/CharSequence;Lorg/intellij/markdown/ast/ASTNode;I)V", "getBuffer", "()Ljava/lang/CharSequence;", "getTree", "()Lorg/intellij/markdown/ast/ASTNode;", "getBufferHash", "()I", "intellij.markdown"})
    private static final class ParsingResult {
        @NotNull
        private final CharSequence buffer;
        @NotNull
        private final ASTNode tree;
        private final int bufferHash;

        public ParsingResult(@NotNull CharSequence buffer, @NotNull ASTNode tree, int bufferHash) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            this.buffer = buffer;
            this.tree = tree;
            this.bufferHash = bufferHash;
        }

        public /* synthetic */ ParsingResult(CharSequence charSequence, ASTNode aSTNode, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                n = charSequence.hashCode();
            }
            this(charSequence, aSTNode, n);
        }

        @NotNull
        public final CharSequence getBuffer() {
            return this.buffer;
        }

        @NotNull
        public final ASTNode getTree() {
            return this.tree;
        }

        public final int getBufferHash() {
            return this.bufferHash;
        }
    }
}

