/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.jvm;

import com.jetbrains.fus.reporting.FileHandle;
import com.jetbrains.fus.reporting.FileStorageMode;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\bH\u0016R\u0014\u0010\n\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/fus/reporting/jvm/InMemoryFileHandle;", "Lcom/jetbrains/fus/reporting/FileHandle;", "path", "", "mode", "Lcom/jetbrains/fus/reporting/FileStorageMode;", "files", "", "", "(Ljava/lang/String;Lcom/jetbrains/fus/reporting/FileStorageMode;Ljava/util/Map;)V", "buffer", "getBuffer", "()[B", "close", "", "exists", "", "length", "", "read", "", "index", "", "dstBuffer", "readAll", "write", "bytes", "api-jvm-defaults"})
@SourceDebugExtension(value={"SMAP\nInMemoryJvmFileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InMemoryJvmFileStorage.kt\ncom/jetbrains/fus/reporting/jvm/InMemoryFileHandle\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,87:1\n372#2,7:88\n*S KotlinDebug\n*F\n+ 1 InMemoryJvmFileStorage.kt\ncom/jetbrains/fus/reporting/jvm/InMemoryFileHandle\n*L\n42#1:88,7\n*E\n"})
public final class InMemoryFileHandle
implements FileHandle {
    @NotNull
    private final String path;
    @NotNull
    private final FileStorageMode mode;
    @NotNull
    private final Map<String, byte[]> files;

    public InMemoryFileHandle(@NotNull String path, @NotNull FileStorageMode mode, @NotNull Map<String, byte[]> files) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.path = path;
        this.mode = mode;
        this.files = files;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] getBuffer() {
        Object object;
        void $this$getOrPut$iv;
        Map<String, byte[]> map2 = this.files;
        String key$iv = this.path;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            byte[] answer$iv = new byte[]{};
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (byte[])object;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean exists() {
        return this.files.containsKey(this.path);
    }

    @Override
    public long length() {
        return this.getBuffer().length;
    }

    @Override
    @NotNull
    public byte[] readAll() {
        byte[] byArray = this.getBuffer();
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        return byArray2;
    }

    @Override
    @NotNull
    public byte[] read(int index, @NotNull byte[] dstBuffer) {
        Intrinsics.checkNotNullParameter((Object)dstBuffer, (String)"dstBuffer");
        if (!this.exists() || index >= this.getBuffer().length) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for file " + this.path + " with size " + this.getBuffer().length);
        }
        int bytesToCopy = Math.min(dstBuffer.length, this.getBuffer().length - index);
        System.arraycopy(this.getBuffer(), index, dstBuffer, 0, bytesToCopy);
        return dstBuffer;
    }

    @Override
    public byte read(int index) {
        if (!this.exists() || index >= this.getBuffer().length) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds for file " + this.path + " with size " + this.getBuffer().length);
        }
        return this.getBuffer()[index];
    }

    @Override
    public void write(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        if (this.mode == FileStorageMode.READ) {
            throw new IllegalStateException("Cannot write to file opened in read-only mode");
        }
        byte[] currentBytes = this.exists() ? this.getBuffer() : new byte[]{};
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        outputStream2.write(currentBytes);
        outputStream2.write(bytes);
        Map<String, byte[]> map2 = this.files;
        String string2 = this.path;
        byte[] byArray = outputStream2.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"outputStream.toByteArray()");
        byte[] byArray2 = byArray;
        map2.put(string2, byArray2);
    }
}

