/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.build.events.MessageEvent;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleExtensions;
import com.intellij.platform.workspace.jps.entities.ModuleId;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.pom.java.AcceptedLanguageLevelsSettings;
import com.intellij.pom.java.JavaRelease;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridges;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.config.MavenConfig;
import org.jetbrains.idea.maven.config.MavenConfigSettings;
import org.jetbrains.idea.maven.importing.NonAcceptedJavaLevelIssue;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenSource;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenInSpecificPath;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenServerSettings;
import org.jetbrains.idea.maven.server.RemotePathTransformerFactory;
import org.jetbrains.idea.maven.utils.MavenEelUtil;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.PrefixStringEncoder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u00a1\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u0019J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001dJ\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b J\u0017\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\"J\u001f\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\"J\u0017\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b$J%\u0010%\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u000e\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070'H\u0000\u00a2\u0006\u0002\b(J\u001d\u0010)\u001a\u0004\u0018\u00010\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001c0+H\u0000\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0000\u00a2\u0006\u0002\b1J\u0015\u00102\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0000\u00a2\u0006\u0002\b3J(\u00104\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u0006H\u0002J\b\u00108\u001a\u00020.H\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u0002000+2\u0006\u0010:\u001a\u00020\u001cH\u0002J\u001b\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00060+2\u0006\u0010:\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b<J#\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00060+2\u0006\u0010:\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b>J\u0015\u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\bAJ\u0015\u0010B\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\bCJ\u0018\u0010D\u001a\u00020\u00072\u0006\u0010:\u001a\u00020E2\u0006\u0010F\u001a\u00020\u0007H\u0007J\u0015\u0010G\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\bHJ\u0018\u0010I\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010F\u001a\u00020\u0007H\u0002J\u000e\u0010J\u001a\u00020.2\u0006\u0010K\u001a\u00020LJ\u0010\u0010M\u001a\u00020.2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0015\u0010N\u001a\u00020.2\u0006\u0010O\u001a\u00020PH\u0000\u00a2\u0006\u0002\bQJ\u0012\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010O\u001a\u00020PH\u0007J\u001a\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010:\u001a\u00020E2\u0006\u0010T\u001a\u00020\u0006H\u0007J\u0011\u0010U\u001a\u00020V*\u00020PH\u0000\u00a2\u0006\u0002\bWJ\f\u0010U\u001a\u00020V*\u00020XH\u0007J#\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u00060+2\u0006\u0010:\u001a\u00020E2\u0006\u0010Z\u001a\u00020SH\u0000\u00a2\u0006\u0002\b[J#\u0010\\\u001a\b\u0012\u0004\u0012\u00020X0+2\u0006\u0010:\u001a\u00020E2\u0006\u0010Z\u001a\u00020SH\u0000\u00a2\u0006\u0002\b]J\u001f\u0010^\u001a\u0004\u0018\u00010P2\u0006\u0010:\u001a\u00020E2\u0006\u0010_\u001a\u00020SH\u0000\u00a2\u0006\u0002\b`J\u0017\u0010a\u001a\b\u0012\u0004\u0012\u00020L0+*\u00020\u001cH\u0000\u00a2\u0006\u0002\bbJ\f\u0010f\u001a\u00020.*\u000200H\u0002J\u0012\u0010n\u001a\b\u0012\u0004\u0012\u0002000+*\u00020oH\u0002J\u0012\u0010p\u001a\b\u0012\u0004\u0012\u0002000+*\u00020oH\u0002J\u0017\u0010q\u001a\b\u0012\u0004\u0012\u00020L0+*\u00020oH\u0000\u00a2\u0006\u0002\brJ\u0017\u0010s\u001a\b\u0012\u0004\u0012\u00020L0+*\u00020oH\u0000\u00a2\u0006\u0002\btJ\u001a\u0010u\u001a\b\u0012\u0004\u0012\u00020\u00060v*\u00020\u001c2\u0006\u0010w\u001a\u00020LH\u0002J\u001c\u0010{\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010w\u001a\u00020LH\u0002J\u001c\u0010|\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010}\u001a\u00020oH\u0002J)\u0010~\u001a\u00020\u007f2\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u00062\u0014\u0010\u0081\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0082\u0001H\u0002J*\u0010\u0083\u0001\u001a\u00020\u007f2\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u00062\u0014\u0010\u0085\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0082\u0001H\u0002J-\u0010\u008a\u0001\u001a\u0004\u0018\u00010L*\u00020\u001c2\t\u0010\u008b\u0001\u001a\u0004\u0018\u00010\u00062\t\u0010\u008c\u0001\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\"\u0010\u008d\u0001\u001a\b0\u0006\u00a2\u0006\u0003\b\u008e\u0001*\u00020\u001c2\u0007\u0010\u008f\u0001\u001a\u00020.H\u0000\u00a2\u0006\u0003\b\u0090\u0001J\u0015\u0010\u0093\u0001\u001a\u0004\u0018\u00010o*\u00020\u001cH\u0000\u00a2\u0006\u0003\b\u0094\u0001J \u0010\u0095\u0001\u001a\u00020\u00062\u0006\u0010:\u001a\u00020E2\u0007\u0010\u0096\u0001\u001a\u00020\u0006H\u0000\u00a2\u0006\u0003\b\u0097\u0001J,\u0010\u0098\u0001\u001a\u00030\u0099\u00012\u0006\u0010:\u001a\u00020E2\b\u0010\u009a\u0001\u001a\u00030\u009b\u00012\b\u0010\u009c\u0001\u001a\u00030\u009d\u0001H\u0000\u00a2\u0006\u0003\b\u009e\u0001J\u0016\u0010\u009f\u0001\u001a\u0005\u0018\u00010\u00a0\u00012\b\u0010\u009a\u0001\u001a\u00030\u009b\u0001H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00060+*\u00020\u001c8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bd\u0010eR\u001e\u0010g\u001a\b\u0012\u0004\u0012\u00020L0+*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bh\u0010eR\u001e\u00109\u001a\b\u0012\u0004\u0012\u0002000+*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bi\u0010eR\u001e\u0010j\u001a\b\u0012\u0004\u0012\u00020L0+*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bk\u0010eR\u001e\u0010l\u001a\b\u0012\u0004\u0012\u00020L0+*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bm\u0010eR$\u0010x\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u001c8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\by\u0010zR\u001c\u0010\u0086\u0001\u001a\u00030\u0087\u0001*\u00020\u001c8@X\u0080\u0004\u00a2\u0006\b\u001a\u0006\b\u0088\u0001\u0010\u0089\u0001R\u001c\u0010w\u001a\u0004\u0018\u00010L*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u0091\u0001\u0010\u0092\u0001\u00a8\u0006\u00a2\u0001"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenImportUtil;", "", "<init>", "()V", "MAVEN_IDEA_PLUGIN_LEVELS", "", "", "Lcom/intellij/pom/java/LanguageLevel;", "COMPILER_PLUGIN_GROUP_ID", "COMPILER_PLUGIN_ARTIFACT_ID", "MAIN_SUFFIX", "TEST_SUFFIX", "compileSourceRootEncoder", "Lorg/jetbrains/idea/maven/utils/PrefixStringEncoder;", "PHASE_COMPILE", "PHASE_TEST_COMPILE", "GOAL_COMPILE", "GOAL_TEST_COMPILE", "EXECUTION_COMPILE", "EXECUTION_TEST_COMPILE", "getArtifactUrlForClassifierAndExtension", "artifact", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "classifier", "extension", "getArtifactUrlForClassifierAndExtension$intellij_maven", "getSourceLanguageLevel", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "getSourceLanguageLevel$intellij_maven", "executionId", "getTestSourceLanguageLevel", "getTestSourceLanguageLevel$intellij_maven", "getTargetLanguageLevel", "getTargetLanguageLevel$intellij_maven", "getTestTargetLanguageLevel", "getTestTargetLanguageLevel$intellij_maven", "getLanguageLevel", "supplier", "Ljava/util/function/Supplier;", "getLanguageLevel$intellij_maven", "getMaxMavenJavaVersion", "projects", "", "getMaxMavenJavaVersion$intellij_maven", "isTestCompileExecution", "", "e", "Lorg/jetbrains/idea/maven/model/MavenPlugin$Execution;", "isTestCompileExecution$intellij_maven", "isCompileExecution", "isCompileExecution$intellij_maven", "checkExecution", "phase", "goal", "defaultExecId", "multiReleaseOutputSyncEnabled", "compilerExecutions", "project", "getNonDefaultCompilerExecutions", "getNonDefaultCompilerExecutions$intellij_maven", "getCompileSourceRoots", "getCompileSourceRoots$intellij_maven", "escapeCompileSourceRootModuleSuffix", "suffix", "escapeCompileSourceRootModuleSuffix$intellij_maven", "unescapeCompileSourceRootModuleSuffix", "unescapeCompileSourceRootModuleSuffix$intellij_maven", "adjustLevelAndNotify", "Lcom/intellij/openapi/project/Project;", "level", "getDefaultLevel", "getDefaultLevel$intellij_maven", "adjustPreviewLanguageLevel", "isPreviewText", "child", "Lorg/jdom/Element;", "isReleaseCompilerProp", "isMainOrTestModule", "module", "Lcom/intellij/openapi/module/Module;", "isMainOrTestModule$intellij_maven", "findPomXml", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleName", "getMavenModuleType", "Lorg/jetbrains/idea/maven/importing/StandardMavenModuleType;", "getMavenModuleType$intellij_maven", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "getModuleNames", "pomXml", "getModuleNames$intellij_maven", "getModuleEntities", "getModuleEntities$intellij_maven", "createPreviewModule", "contentRoot", "createPreviewModule$intellij_maven", "compilerConfigsForCompilePhase", "compilerConfigsForCompilePhase$intellij_maven", "declaredAnnotationProcessors", "getDeclaredAnnotationProcessors$intellij_maven", "(Lorg/jetbrains/idea/maven/project/MavenProject;)Ljava/util/List;", "isCompilePhase", "pluginConfig", "getPluginConfig", "getCompilerExecutions", "compilerConfigs", "getCompilerConfigs", "testCompilerConfigs", "getTestCompilerConfigs", "getCompileExecutions", "Lorg/jetbrains/idea/maven/model/MavenPlugin;", "getTestCompileExecutions", "getCompileExecutionConfigurations", "getCompileExecutionConfigurations$intellij_maven", "getTestCompileExecutionConfigurations", "getTestCompileExecutionConfigurations$intellij_maven", "getDeclaredAnnotationProcessors", "", "compilerConfig", "annotationProcessorOptions", "getAnnotationProcessorOptions$intellij_maven", "(Lorg/jetbrains/idea/maven/project/MavenProject;)Ljava/util/Map;", "getAnnotationProcessorOptionsFromCompilerConfig", "getAnnotationProcessorOptionsFromProcessorPlugin", "bscMavenPlugin", "addAnnotationProcessorOptionFromParameterString", "", "compilerArguments", "res", "", "addAnnotationProcessorOption", "compilerArg", "optionsMap", "procMode", "Lorg/jetbrains/idea/maven/project/MavenProject$ProcMode;", "getProcMode$intellij_maven", "(Lorg/jetbrains/idea/maven/project/MavenProject;)Lorg/jetbrains/idea/maven/project/MavenProject$ProcMode;", "getPluginExecutionConfiguration", "groupId", "artifactId", "getAnnotationProcessorDirectory", "Lcom/intellij/openapi/util/NlsSafe;", "testSources", "getAnnotationProcessorDirectory$intellij_maven", "getCompilerConfig", "(Lorg/jetbrains/idea/maven/project/MavenProject;)Lorg/jdom/Element;", "findCompilerPlugin", "findCompilerPlugin$intellij_maven", "guessExistingEmbedderDir", "multiModuleProjectDirectory", "guessExistingEmbedderDir$intellij_maven", "convertSettings", "Lorg/jetbrains/idea/maven/server/MavenServerSettings;", "settings", "Lorg/jetbrains/idea/maven/project/MavenGeneralSettings;", "mavenDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "convertSettings$intellij_maven", "getGlobalConfigFromMavenConfig", "Ljava/nio/file/Path;", "MavenLanguageLevelFinder", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenImportUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenImportUtil.kt\norg/jetbrains/idea/maven/importing/MavenImportUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 EntityStorage.kt\ncom/intellij/platform/workspace/storage/EntityStorageKt\n+ 5 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,745:1\n1374#2:746\n1460#2,5:747\n774#2:752\n865#2,2:753\n1563#2:755\n1634#2,3:756\n774#2:759\n865#2,2:760\n295#2,2:762\n1617#2,9:764\n1869#2:773\n1870#2:775\n1626#2:776\n1761#2,3:777\n1761#2,3:780\n1563#2:783\n1634#2,3:784\n774#2:789\n865#2,2:790\n1617#2,9:792\n1869#2:801\n1870#2:803\n1626#2:804\n1869#2,2:805\n774#2:807\n865#2,2:808\n1617#2,9:810\n1869#2:819\n1870#2:821\n1626#2:822\n1374#2:824\n1460#2,5:825\n1617#2,9:830\n1869#2:839\n1870#2:841\n1626#2:842\n774#2:843\n865#2,2:844\n774#2:846\n865#2,2:847\n1617#2,9:849\n1869#2:858\n1870#2:860\n1626#2:861\n1617#2,9:862\n1869#2:871\n1870#2:873\n1626#2:874\n1#3:774\n1#3:788\n1#3:802\n1#3:820\n1#3:823\n1#3:840\n1#3:859\n1#3:872\n66#4:787\n106#5:875\n78#5,22:876\n*S KotlinDebug\n*F\n+ 1 MavenImportUtil.kt\norg/jetbrains/idea/maven/importing/MavenImportUtil\n*L\n140#1:746\n140#1:747,5\n178#1:752\n178#1:753,2\n179#1:755\n179#1:756,3\n180#1:759\n180#1:760,2\n185#1:762,2\n189#1:764,9\n189#1:773\n189#1:775\n189#1:776\n314#1:777,3\n315#1:780,3\n371#1:783\n371#1:784,3\n401#1:789\n401#1:790,2\n402#1:792,9\n402#1:801\n402#1:803\n402#1:804\n403#1:805,2\n410#1:807\n410#1:808,2\n411#1:810,9\n411#1:819\n411#1:821\n411#1:822\n412#1:824\n412#1:825,5\n434#1:830,9\n434#1:839\n434#1:841\n434#1:842\n445#1:843\n445#1:844,2\n449#1:846\n449#1:847,2\n453#1:849,9\n453#1:858\n453#1:860\n453#1:861\n457#1:862,9\n457#1:871\n457#1:873\n457#1:874\n189#1:774\n402#1:802\n411#1:820\n434#1:840\n453#1:859\n457#1:872\n378#1:787\n574#1:875\n574#1:876,22\n*E\n"})
public final class MavenImportUtil {
    @NotNull
    public static final MavenImportUtil INSTANCE = new MavenImportUtil();
    @NotNull
    private static final Map<String, LanguageLevel> MAVEN_IDEA_PLUGIN_LEVELS;
    @NotNull
    private static final String COMPILER_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    @NotNull
    private static final String COMPILER_PLUGIN_ARTIFACT_ID = "maven-compiler-plugin";
    @NotNull
    public static final String MAIN_SUFFIX = "main";
    @NotNull
    public static final String TEST_SUFFIX = "test";
    @NotNull
    private static final PrefixStringEncoder compileSourceRootEncoder;
    @NotNull
    private static final String PHASE_COMPILE = "compile";
    @NotNull
    private static final String PHASE_TEST_COMPILE = "test-compile";
    @NotNull
    private static final String GOAL_COMPILE = "compile";
    @NotNull
    private static final String GOAL_TEST_COMPILE = "testCompile";
    @NotNull
    private static final String EXECUTION_COMPILE = "default-compile";
    @NotNull
    private static final String EXECUTION_TEST_COMPILE = "default-testCompile";

    private MavenImportUtil() {
    }

    @NotNull
    public final String getArtifactUrlForClassifierAndExtension$intellij_maven(@NotNull MavenArtifact artifact, @Nullable String classifier, @Nullable String extension) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        String newPath = artifact.getPathForExtraArtifact(classifier, extension);
        return VirtualFileManager.constructUrl((String)"jar", (String)newPath) + "!/";
    }

    @Nullable
    public final LanguageLevel getSourceLanguageLevel$intellij_maven(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        return new MavenLanguageLevelFinder(mavenProject, true, false, null, 8, null).getMavenLanguageLevel();
    }

    @Nullable
    public final LanguageLevel getSourceLanguageLevel$intellij_maven(@NotNull MavenProject mavenProject, @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        return new MavenLanguageLevelFinder(mavenProject, true, false, executionId).getMavenLanguageLevel();
    }

    @Nullable
    public final LanguageLevel getTestSourceLanguageLevel$intellij_maven(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        return new MavenLanguageLevelFinder(mavenProject, true, true, null, 8, null).getMavenLanguageLevel();
    }

    @Nullable
    public final LanguageLevel getTargetLanguageLevel$intellij_maven(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        return new MavenLanguageLevelFinder(mavenProject, false, false, null, 8, null).getMavenLanguageLevel();
    }

    @Nullable
    public final LanguageLevel getTargetLanguageLevel$intellij_maven(@NotNull MavenProject mavenProject, @NotNull String executionId) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
        return new MavenLanguageLevelFinder(mavenProject, false, false, executionId).getMavenLanguageLevel();
    }

    @Nullable
    public final LanguageLevel getTestTargetLanguageLevel$intellij_maven(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        return new MavenLanguageLevelFinder(mavenProject, false, true, null, 8, null).getMavenLanguageLevel();
    }

    @NotNull
    public final LanguageLevel getLanguageLevel$intellij_maven(@NotNull MavenProject mavenProject, @NotNull Supplier<LanguageLevel> supplier) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
        LanguageLevel level = null;
        Element cfg = mavenProject.getPluginConfiguration("com.googlecode", "maven-idea-plugin");
        if (cfg != null) {
            String key;
            String string = key = cfg.getChildTextTrim("jdkLevel");
            LanguageLevel languageLevel = level = string == null ? null : MAVEN_IDEA_PLUGIN_LEVELS.get(string);
        }
        if (level == null) {
            level = supplier.get();
        }
        if (level == null) {
            level = this.getDefaultLevel$intellij_maven(mavenProject);
        }
        if (level.isAtLeast(LanguageLevel.JDK_11)) {
            level = this.adjustPreviewLanguageLevel(mavenProject, level);
        }
        return level;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final LanguageLevel getMaxMavenJavaVersion$intellij_maven(@NotNull List<MavenProject> projects) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(projects, (String)"projects");
        Iterable $this$flatMap$iv = projects;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MavenProject it = (MavenProject)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new LanguageLevel[]{INSTANCE.getSourceLanguageLevel$intellij_maven(it), INSTANCE.getTestSourceLanguageLevel$intellij_maven(it), INSTANCE.getTargetLanguageLevel$intellij_maven(it), INSTANCE.getTestTargetLanguageLevel$intellij_maven(it)};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable iterable2 = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        Comparator comparator = Comparator.naturalOrder();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"naturalOrder(...)");
        LanguageLevel languageLevel = (LanguageLevel)CollectionsKt.maxWithOrNull((Iterable)iterable2, comparator);
        if (languageLevel == null) {
            LanguageLevel languageLevel2 = JavaRelease.getHighest();
            languageLevel = languageLevel2;
            Intrinsics.checkNotNullExpressionValue((Object)languageLevel2, (String)"getHighest(...)");
        }
        LanguageLevel maxLevel = languageLevel;
        return maxLevel;
    }

    public final boolean isTestCompileExecution$intellij_maven(@NotNull MavenPlugin.Execution e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.checkExecution(e, PHASE_TEST_COMPILE, GOAL_TEST_COMPILE, EXECUTION_TEST_COMPILE);
    }

    public final boolean isCompileExecution$intellij_maven(@NotNull MavenPlugin.Execution e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.checkExecution(e, "compile", "compile", EXECUTION_COMPILE);
    }

    private final boolean checkExecution(MavenPlugin.Execution e, String phase, String goal, String defaultExecId) {
        return !Intrinsics.areEqual((Object)"none", (Object)e.getPhase()) && (Intrinsics.areEqual((Object)phase, (Object)e.getPhase()) || e.getGoals() != null && e.getGoals().contains(goal) || Intrinsics.areEqual((Object)defaultExecId, (Object)e.getExecutionId()));
    }

    private final boolean multiReleaseOutputSyncEnabled() {
        return Registry.Companion.is("maven.import.separate.main.and.test.modules.when.multiReleaseOutput");
    }

    private final List<MavenPlugin.Execution> compilerExecutions(MavenProject project) {
        Object object = this.findCompilerPlugin$intellij_maven(project);
        if (object == null || (object = object.getExecutions()) == null) {
            return CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final List<String> getNonDefaultCompilerExecutions$intellij_maven(@NotNull MavenProject project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!this.multiReleaseOutputSyncEnabled()) {
            return CollectionsKt.emptyList();
        }
        $this$filter$iv = this.compilerExecutions(project);
        $i$f$filter = false;
        var4_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it /* !! */  = (MavenPlugin.Execution)element$iv$iv;
            $i$a$-filter-MavenImportUtil$getNonDefaultCompilerExecutions$1 = false;
            if (!Intrinsics.areEqual((Object)it /* !! */ .getPhase(), (Object)"compile") && it /* !! */ .getPhase() != null) ** GOTO lbl-1000
            v0 /* !! */  = it /* !! */ .getConfigurationElement();
            v1 = v0 /* !! */  != null && (v0 /* !! */  = v0 /* !! */ .getChild("compileSourceRoots")) != null && (v0 /* !! */  = v0 /* !! */ .getChildren()) != null ? ((Collection)v0 /* !! */ ).isEmpty() == false : false;
            if (v1) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it /* !! */  = (MavenPlugin.Execution)item$iv$iv;
            var11_11 = destination$iv$iv;
            $i$a$-map-MavenImportUtil$getNonDefaultCompilerExecutions$2 = false;
            var11_11.add(it /* !! */ .getExecutionId());
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it /* !! */  = (String)element$iv$iv;
            $i$a$-filter-MavenImportUtil$getNonDefaultCompilerExecutions$3 = false;
            if (!(Intrinsics.areEqual((Object)it /* !! */ , (Object)"default-compile") == false && Intrinsics.areEqual((Object)it /* !! */ , (Object)"default-testCompile") == false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getCompileSourceRoots$intellij_maven(@NotNull MavenProject project, @NotNull String executionId) {
        List list;
        List list2;
        Element element;
        Object v0;
        Object element$iv;
        Object object;
        Iterable iterable;
        block5: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)executionId, (String)"executionId");
            iterable = this.compilerExecutions(project);
            boolean $i$f$firstOrNull = false;
            object = $this$firstOrNull$iv.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getExecutionId(), (Object)executionId)) continue;
                v0 = element$iv;
                break block5;
            }
            v0 = null;
        }
        MavenPlugin.Execution execution = v0;
        if (execution != null && (iterable = execution.getConfigurationElement()) != null && (element = iterable.getChild("compileSourceRoots")) != null && (object = element.getChildren()) != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            element$iv = (Iterable)object;
            boolean $i$f$mapNotNull = false;
            void bl = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Element it = (Element)element$iv$iv;
                boolean bl3 = false;
                if (it.getTextTrim() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final String escapeCompileSourceRootModuleSuffix$intellij_maven(@NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return compileSourceRootEncoder.encode(suffix);
    }

    @NotNull
    public final String unescapeCompileSourceRootModuleSuffix$intellij_maven(@NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        return compileSourceRootEncoder.decode(suffix);
    }

    @JvmStatic
    @NotNull
    public static final LanguageLevel adjustLevelAndNotify(@NotNull Project project, @NotNull LanguageLevel level) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        LanguageLevel level2 = level;
        if (!AcceptedLanguageLevelsSettings.isLanguageLevelAccepted((LanguageLevel)level2)) {
            LanguageLevel languageLevel;
            LanguageLevel languageLevel2 = AcceptedLanguageLevelsSettings.getHighestAcceptedLevel();
            Intrinsics.checkNotNullExpressionValue((Object)languageLevel2, (String)"getHighestAcceptedLevel(...)");
            LanguageLevel highestAcceptedLevel = languageLevel2;
            if (highestAcceptedLevel.isLessThan(level2)) {
                MavenProjectsManager.getInstance(project).getSyncConsole().addBuildIssue(new NonAcceptedJavaLevelIssue(level2), MessageEvent.Kind.WARNING);
            }
            if (highestAcceptedLevel.isAtLeast(level2)) {
                LanguageLevel languageLevel3 = JavaRelease.getHighest();
                languageLevel = languageLevel3;
                Intrinsics.checkNotNullExpressionValue((Object)languageLevel3, (String)"getHighest(...)");
            } else {
                languageLevel = highestAcceptedLevel;
            }
            level2 = languageLevel;
        }
        return level2;
    }

    @NotNull
    public final LanguageLevel getDefaultLevel$intellij_maven(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        MavenPlugin plugin = this.findCompilerPlugin$intellij_maven(mavenProject);
        if (plugin != null && plugin.getVersion() != null) {
            if (VersionComparatorUtil.compare((String)"3.11.0", (String)plugin.getVersion()) <= 0) {
                return LanguageLevel.JDK_1_8;
            }
            if (VersionComparatorUtil.compare((String)"3.9.0", (String)plugin.getVersion()) <= 0) {
                return LanguageLevel.JDK_1_7;
            }
            if (VersionComparatorUtil.compare((String)"3.8.0", (String)plugin.getVersion()) <= 0) {
                return LanguageLevel.JDK_1_6;
            }
            return LanguageLevel.JDK_1_5;
        }
        return LanguageLevel.JDK_1_5;
    }

    private final LanguageLevel adjustPreviewLanguageLevel(MavenProject mavenProject, LanguageLevel level) {
        block17: {
            LanguageLevel languageLevel;
            block18: {
                boolean bl;
                block16: {
                    Element it;
                    boolean bl2;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    Element compilerArgs;
                    block15: {
                        String enablePreviewProperty = mavenProject.getProperties().getProperty("maven.compiler.enablePreview");
                        if (Boolean.parseBoolean(enablePreviewProperty)) {
                            LanguageLevel languageLevel2 = level.getPreviewLevel();
                            if (languageLevel2 == null) {
                                languageLevel2 = level;
                            }
                            return languageLevel2;
                        }
                        Element compilerConfiguration = mavenProject.getPluginConfiguration(COMPILER_PLUGIN_GROUP_ID, COMPILER_PLUGIN_ARTIFACT_ID);
                        if (compilerConfiguration == null) break block17;
                        String enablePreviewParameter = compilerConfiguration.getChildTextTrim("enablePreview");
                        if (Boolean.parseBoolean(enablePreviewParameter)) {
                            LanguageLevel languageLevel3 = level.getPreviewLevel();
                            if (languageLevel3 == null) {
                                languageLevel3 = level;
                            }
                            return languageLevel3;
                        }
                        compilerArgs = compilerConfiguration.getChild("compilerArgs");
                        if (compilerArgs == null) break block17;
                        if (this.isPreviewText(compilerArgs)) break block18;
                        List list = compilerArgs.getChildren("arg");
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
                        $this$any$iv = list;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (Element)element$iv;
                                boolean bl3 = false;
                                Intrinsics.checkNotNull((Object)it);
                                if (!INSTANCE.isPreviewText(it)) continue;
                                bl2 = true;
                                break block15;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) break block18;
                    List list = compilerArgs.getChildren("compilerArg");
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
                    $this$any$iv = list;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (Element)element$iv;
                            boolean bl4 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!INSTANCE.isPreviewText(it)) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block17;
            }
            if ((languageLevel = level.getPreviewLevel()) == null) {
                languageLevel = level;
            }
            return languageLevel;
        }
        return level;
    }

    public final boolean isPreviewText(@NotNull Element child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return Intrinsics.areEqual((Object)"--enable-preview", (Object)child.getTextTrim());
    }

    private final boolean isReleaseCompilerProp(MavenProject mavenProject) {
        return StringUtil.compareVersionNumbers((String)MavenUtil.INSTANCE.getCompilerPluginVersion(mavenProject), (String)"3.6") >= 0;
    }

    public final boolean isMainOrTestModule$intellij_maven(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        StandardMavenModuleType type = this.getMavenModuleType$intellij_maven(module);
        return type == StandardMavenModuleType.MAIN_ONLY || type == StandardMavenModuleType.TEST_ONLY;
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile findPomXml(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return MavenImportUtil.findPomXml(project, string);
    }

    @JvmStatic
    @Nullable
    public static final VirtualFile findPomXml(@NotNull Project project, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        ImmutableEntityStorage storage = WorkspaceModelKt.getWorkspaceModel((Project)project).getCurrentSnapshot();
        Object object = (ModuleEntity)storage.resolve((SymbolicEntityId)new ModuleId(moduleName));
        if (object == null || (object = ModuleExtensions.getExModuleOptions((ModuleEntity)object)) == null || (object = object.getLinkedProjectId()) == null || (object = NioPathUtil.toNioPathOrNull((String)object)) == null) {
            return null;
        }
        Object pomPath = object;
        return VirtualFileManager.getInstance().findFileByNioPath((Path)pomPath);
    }

    @NotNull
    public final StandardMavenModuleType getMavenModuleType$intellij_maven(@NotNull Module $this$getMavenModuleType) {
        Intrinsics.checkNotNullParameter((Object)$this$getMavenModuleType, (String)"<this>");
        StandardMavenModuleType standardMavenModuleType = StandardMavenModuleType.SINGLE_MODULE;
        ModuleEntity moduleEntity = ModuleBridges.findModuleEntity((Module)$this$getMavenModuleType);
        if (moduleEntity == null) {
            return standardMavenModuleType;
        }
        ModuleEntity moduleEntity2 = moduleEntity;
        return this.getMavenModuleType(moduleEntity2);
    }

    @ApiStatus.Internal
    @NotNull
    public final StandardMavenModuleType getMavenModuleType(@NotNull ModuleEntity $this$getMavenModuleType) {
        StandardMavenModuleType standardMavenModuleType;
        Intrinsics.checkNotNullParameter((Object)$this$getMavenModuleType, (String)"<this>");
        StandardMavenModuleType standardMavenModuleType2 = StandardMavenModuleType.SINGLE_MODULE;
        Object object = ModuleExtensions.getExModuleOptions((ModuleEntity)$this$getMavenModuleType);
        if (object == null || (object = object.getExternalSystemModuleType()) == null) {
            return standardMavenModuleType2;
        }
        Object moduleTypeString = object;
        try {
            standardMavenModuleType = StandardMavenModuleType.valueOf((String)moduleTypeString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MavenLog.LOG.warn("Unknown module type: " + (String)moduleTypeString);
            standardMavenModuleType = standardMavenModuleType2;
        }
        return standardMavenModuleType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getModuleNames$intellij_maven(@NotNull Project project, @NotNull VirtualFile pomXml) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pomXml, (String)"pomXml");
        Iterable $this$map$iv = this.getModuleEntities$intellij_maven(project, pomXml);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModuleEntity moduleEntity = (ModuleEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final List<ModuleEntity> getModuleEntities$intellij_maven(@NotNull Project project, @NotNull VirtualFile pomXml) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pomXml, (String)"pomXml");
        ImmutableEntityStorage storage = WorkspaceModelKt.getWorkspaceModel((Project)project).getCurrentSnapshot();
        Path path = pomXml.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        Path pomXmlPath = path;
        EntityStorage $this$entities$iv = (EntityStorage)storage;
        boolean $i$f$entities = false;
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)$this$entities$iv.entities(ModuleEntity.class), arg_0 -> MavenImportUtil.getModuleEntities$lambda$0(pomXmlPath, arg_0)));
    }

    @Nullable
    public final Module createPreviewModule$intellij_maven(@NotNull Project project, @NotNull VirtualFile contentRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        return (Module)WriteAction.compute(() -> MavenImportUtil.createPreviewModule$lambda$0(contentRoot, project));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Element> compilerConfigsForCompilePhase$intellij_maven(@NotNull MavenProject $this$compilerConfigsForCompilePhase) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$compilerConfigsForCompilePhase, (String)"<this>");
        ArrayList<Element> result2 = new ArrayList<Element>(1);
        Element element = $this$compilerConfigsForCompilePhase.getPluginConfiguration(COMPILER_PLUGIN_GROUP_ID, COMPILER_PLUGIN_ARTIFACT_ID);
        if (element != null) {
            Element p0 = element;
            boolean bl = false;
            result2.add(p0);
        }
        MavenPlugin mavenPlugin = this.findCompilerPlugin$intellij_maven($this$compilerConfigsForCompilePhase);
        if (mavenPlugin != null && (list = mavenPlugin.getExecutions()) != null) {
            void $this$forEach$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable bl = list;
            boolean $i$f$filter22 = false;
            void var8_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!INSTANCE.isCompilePhase(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $i$f$filter22 = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Element it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv$iv;
                boolean bl4 = false;
                if (it.getConfigurationElement() == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Element p0 = (Element)element$iv;
                boolean bl6 = false;
                result2.add(p0);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getDeclaredAnnotationProcessors$intellij_maven(@NotNull MavenProject $this$declaredAnnotationProcessors) {
        void $this$flatMapTo$iv$iv;
        List<Element> list;
        List<Element> $this$mapNotNullTo$iv$iv;
        Object it;
        List<Element> $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$declaredAnnotationProcessors, (String)"<this>");
        Iterable $this$filter$iv = this.getCompilerExecutions($this$declaredAnnotationProcessors);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (MavenPlugin.Execution)t;
            boolean bl = false;
            if (!INSTANCE.isCompilePhase((MavenPlugin.Execution)it)) continue;
            destination$iv$iv.add(t);
        }
        Collection<Object> $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean bl = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            Element it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl2 = false;
            MavenPlugin.Execution it2 = (MavenPlugin.Execution)element$iv$iv;
            boolean bl22 = false;
            if (it2.getConfigurationElement() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        if ($this$mapNotNull$iv.isEmpty()) {
            boolean bl3 = false;
            list = INSTANCE.getPluginConfig($this$declaredAnnotationProcessors);
        } else {
            list = $this$mapNotNull$iv;
        }
        List<Element> $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object t : $this$flatMapTo$iv$iv) {
            it = (Element)t;
            boolean bl4 = false;
            Iterable list$iv$iv = INSTANCE.getDeclaredAnnotationProcessors($this$declaredAnnotationProcessors, (Element)it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isCompilePhase(MavenPlugin.Execution $this$isCompilePhase) {
        CharSequence charSequence = $this$isCompilePhase.getPhase();
        return (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && $this$isCompilePhase.getGoals().contains("compile") || Intrinsics.areEqual((Object)$this$isCompilePhase.getPhase(), (Object)"compile");
    }

    private final List<Element> getPluginConfig(MavenProject $this$pluginConfig) {
        Element configuration = $this$pluginConfig.getPluginConfiguration(COMPILER_PLUGIN_GROUP_ID, COMPILER_PLUGIN_ARTIFACT_ID);
        List list = ContainerUtil.createMaybeSingletonList((Object)configuration);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"createMaybeSingletonList(...)");
        return list;
    }

    private final List<MavenPlugin.Execution> getCompilerExecutions(MavenProject $this$compilerExecutions) {
        MavenPlugin plugin = this.findCompilerPlugin$intellij_maven($this$compilerExecutions);
        if (plugin == null) {
            return CollectionsKt.emptyList();
        }
        return this.getCompileExecutions(plugin);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Element> getCompilerConfigs(MavenProject $this$compilerConfigs) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getCompilerExecutions($this$compilerConfigs);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Element it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv$iv;
            boolean bl2 = false;
            if (it.getConfigurationElement() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<Element> getTestCompilerConfigs(MavenProject $this$testCompilerConfigs) {
        MavenPlugin plugin = this.findCompilerPlugin$intellij_maven($this$testCompilerConfigs);
        if (plugin == null) {
            return CollectionsKt.emptyList();
        }
        return this.getTestCompileExecutionConfigurations$intellij_maven(plugin);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MavenPlugin.Execution> getCompileExecutions(MavenPlugin $this$getCompileExecutions) {
        void $this$filterTo$iv$iv;
        List list = $this$getCompileExecutions.getExecutions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExecutions(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.isCompileExecution$intellij_maven(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MavenPlugin.Execution> getTestCompileExecutions(MavenPlugin $this$getTestCompileExecutions) {
        void $this$filterTo$iv$iv;
        List list = $this$getTestCompileExecutions.getExecutions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExecutions(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv$iv;
            boolean bl = false;
            if (!INSTANCE.isTestCompileExecution$intellij_maven(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Element> getCompileExecutionConfigurations$intellij_maven(@NotNull MavenPlugin $this$getCompileExecutionConfigurations) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getCompileExecutionConfigurations, (String)"<this>");
        Iterable $this$mapNotNull$iv = this.getCompileExecutions($this$getCompileExecutionConfigurations);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Element it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv$iv;
            boolean bl2 = false;
            if (it.getConfigurationElement() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Element> getTestCompileExecutionConfigurations$intellij_maven(@NotNull MavenPlugin $this$getTestCompileExecutionConfigurations) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getTestCompileExecutionConfigurations, (String)"<this>");
        Iterable $this$mapNotNull$iv = this.getTestCompileExecutions($this$getTestCompileExecutionConfigurations);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Element it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv$iv;
            boolean bl2 = false;
            if (it.getConfigurationElement() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<String> getDeclaredAnnotationProcessors(MavenProject $this$getDeclaredAnnotationProcessors, Element compilerConfig) {
        List result2;
        block6: {
            block5: {
                result2 = new ArrayList();
                if (this.getProcMode$intellij_maven($this$getDeclaredAnnotationProcessors) == MavenProject.ProcMode.NONE) break block5;
                Element processors = compilerConfig.getChild("annotationProcessors");
                if (processors == null) break block6;
                for (Object e : processors.getChildren("annotationProcessor")) {
                    String processorClassName;
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    Element element = (Element)e;
                    Intrinsics.checkNotNullExpressionValue((Object)element.getTextTrim(), (String)"getTextTrim(...)");
                    if (((CharSequence)processorClassName).length() == 0) continue;
                    result2.add(processorClassName);
                }
                break block6;
            }
            MavenPlugin bscMavenPlugin = MavenProject.findPlugin$default($this$getDeclaredAnnotationProcessors, "org.bsc.maven", "maven-processor-plugin", false, 4, null);
            if (bscMavenPlugin != null) {
                Element bscProcessors;
                Element bscCfg = bscMavenPlugin.getGoalConfiguration("process");
                if (bscCfg == null) {
                    bscCfg = bscMavenPlugin.getConfigurationElement();
                }
                if (bscCfg != null && (bscProcessors = bscCfg.getChild("processors")) != null) {
                    for (Object e : bscProcessors.getChildren("processor")) {
                        String processorClassName;
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        Element element = (Element)e;
                        Intrinsics.checkNotNullExpressionValue((Object)element.getTextTrim(), (String)"getTextTrim(...)");
                        if (((CharSequence)processorClassName).length() == 0) continue;
                        result2.add(processorClassName);
                    }
                }
            }
        }
        return result2;
    }

    @NotNull
    public final Map<String, String> getAnnotationProcessorOptions$intellij_maven(@NotNull MavenProject $this$annotationProcessorOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$annotationProcessorOptions, (String)"<this>");
        Element compilerConfig = this.getCompilerConfig($this$annotationProcessorOptions);
        if (compilerConfig == null) {
            return MapsKt.emptyMap();
        }
        if (this.getProcMode$intellij_maven($this$annotationProcessorOptions) != MavenProject.ProcMode.NONE) {
            return this.getAnnotationProcessorOptionsFromCompilerConfig(compilerConfig);
        }
        MavenPlugin bscMavenPlugin = MavenProject.findPlugin$default($this$annotationProcessorOptions, "org.bsc.maven", "maven-processor-plugin", false, 4, null);
        if (bscMavenPlugin != null) {
            return this.getAnnotationProcessorOptionsFromProcessorPlugin(bscMavenPlugin);
        }
        return MapsKt.emptyMap();
    }

    private final Map<String, String> getAnnotationProcessorOptionsFromCompilerConfig(Element compilerConfig) {
        Element compilerArguments;
        Map res = new LinkedHashMap();
        String compilerArgument = compilerConfig.getChildText("compilerArgument");
        this.addAnnotationProcessorOptionFromParameterString(compilerArgument, res);
        Element compilerArgs = compilerConfig.getChild("compilerArgs");
        if (compilerArgs != null) {
            for (Object e : compilerArgs.getChildren()) {
                String arg;
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Element e2 = (Element)e;
                if (!StringUtil.equals((CharSequence)e2.getName(), (CharSequence)"arg")) continue;
                Intrinsics.checkNotNullExpressionValue((Object)e2.getTextTrim(), (String)"getTextTrim(...)");
                this.addAnnotationProcessorOption(arg, res);
            }
        }
        if ((compilerArguments = compilerConfig.getChild("compilerArguments")) != null) {
            for (Object e : compilerArguments.getChildren()) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Element e3 = (Element)e;
                String string = e3.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String name = string;
                if ((name = StringsKt.removePrefix((String)name, (CharSequence)"-")).length() <= 1 || name.charAt(0) != 'A') continue;
                String string2 = name.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                res.put(string2, e3.getTextTrim());
            }
        }
        return res;
    }

    private final Map<String, String> getAnnotationProcessorOptionsFromProcessorPlugin(MavenPlugin bscMavenPlugin) {
        Element cfg = bscMavenPlugin.getGoalConfiguration("process");
        if (cfg == null) {
            cfg = bscMavenPlugin.getConfigurationElement();
        }
        LinkedHashMap res = new LinkedHashMap();
        if (cfg != null) {
            String compilerArguments = cfg.getChildText("compilerArguments");
            this.addAnnotationProcessorOptionFromParameterString(compilerArguments, res);
            Element optionsElement = cfg.getChild("options");
            if (optionsElement != null) {
                for (Object e : optionsElement.getChildren()) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    Element option = (Element)e;
                    ((Map)res).put(option.getName(), option.getText());
                }
            }
        }
        return res;
    }

    private final void addAnnotationProcessorOptionFromParameterString(String compilerArguments, Map<String, String> res) {
        CharSequence charSequence = compilerArguments;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            ParametersList parametersList = new ParametersList();
            parametersList.addParametersString(compilerArguments);
            for (Object e : parametersList.getParameters()) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String param = (String)e;
                this.addAnnotationProcessorOption(param, res);
            }
        }
    }

    private final void addAnnotationProcessorOption(String compilerArg, Map<String, String> optionsMap) {
        block10: {
            block9: {
                if (compilerArg == null) break block9;
                String $this$trim$iv = compilerArg;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!(((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0)) break block10;
            }
            return;
        }
        if (StringsKt.startsWith$default((String)compilerArg, (String)"-A", (boolean)false, (int)2, null)) {
            int idx = StringsKt.indexOf$default((CharSequence)compilerArg, (char)'=', (int)3, (boolean)false, (int)4, null);
            if (idx >= 0) {
                String string = compilerArg.substring(2, idx);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = compilerArg.substring(idx + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                optionsMap.put(string, string2);
            } else {
                String string = compilerArg.substring(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                optionsMap.put(string, "");
            }
        }
    }

    @NotNull
    public final MavenProject.ProcMode getProcMode$intellij_maven(@NotNull MavenProject $this$procMode) {
        Intrinsics.checkNotNullParameter((Object)$this$procMode, (String)"<this>");
        Element compilerConfiguration = this.getPluginExecutionConfiguration($this$procMode, COMPILER_PLUGIN_GROUP_ID, COMPILER_PLUGIN_ARTIFACT_ID, EXECUTION_COMPILE);
        if (compilerConfiguration == null) {
            compilerConfiguration = this.getCompilerConfig($this$procMode);
        }
        if (compilerConfiguration == null) {
            return MavenProject.ProcMode.BOTH;
        }
        Element procElement = compilerConfiguration.getChild("proc");
        if (procElement != null) {
            String string = procElement.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            String procMode = string;
            return StringsKt.equals((String)"only", (String)procMode, (boolean)true) ? MavenProject.ProcMode.ONLY : (StringsKt.equals((String)"none", (String)procMode, (boolean)true) ? MavenProject.ProcMode.NONE : MavenProject.ProcMode.BOTH);
        }
        String compilerArgument = compilerConfiguration.getChildTextTrim("compilerArgument");
        if (Intrinsics.areEqual((Object)"-proc:none", (Object)compilerArgument)) {
            return MavenProject.ProcMode.NONE;
        }
        if (Intrinsics.areEqual((Object)"-proc:only", (Object)compilerArgument)) {
            return MavenProject.ProcMode.ONLY;
        }
        Element compilerArguments = compilerConfiguration.getChild("compilerArgs");
        if (compilerArguments != null) {
            for (Object e : compilerArguments.getChildren()) {
                String arg;
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Element element = (Element)e;
                Intrinsics.checkNotNullExpressionValue((Object)element.getValue(), (String)"getValue(...)");
                if (Intrinsics.areEqual((Object)"-proc:none", (Object)arg)) {
                    return MavenProject.ProcMode.NONE;
                }
                if (!Intrinsics.areEqual((Object)"-proc:only", (Object)arg)) continue;
                return MavenProject.ProcMode.ONLY;
            }
        }
        return MavenProject.ProcMode.BOTH;
    }

    private final Element getPluginExecutionConfiguration(MavenProject $this$getPluginExecutionConfiguration, String groupId, String artifactId, String executionId) {
        MavenPlugin plugin = MavenProject.findPlugin$default($this$getPluginExecutionConfiguration, groupId, artifactId, false, 4, null);
        if (plugin == null) {
            return null;
        }
        return plugin.getExecutionConfiguration(executionId);
    }

    @NotNull
    public final String getAnnotationProcessorDirectory$intellij_maven(@NotNull MavenProject $this$getAnnotationProcessorDirectory, boolean testSources) {
        Intrinsics.checkNotNullParameter((Object)$this$getAnnotationProcessorDirectory, (String)"<this>");
        if (this.getProcMode$intellij_maven($this$getAnnotationProcessorDirectory) == MavenProject.ProcMode.NONE) {
            MavenPlugin bscMavenPlugin = MavenProject.findPlugin$default($this$getAnnotationProcessorDirectory, "org.bsc.maven", "maven-processor-plugin", false, 4, null);
            Element cfg = $this$getAnnotationProcessorDirectory.getPluginGoalConfiguration(bscMavenPlugin, testSources ? "process-test" : "process");
            if (bscMavenPlugin != null && cfg == null) {
                return $this$getAnnotationProcessorDirectory.getBuildDirectory() + (testSources ? "/generated-sources/apt-test" : "/generated-sources/apt");
            }
            if (cfg != null) {
                Object out = MavenJDOMUtil.findChildValueByPath$default(cfg, "outputDirectory", null, 4, null);
                if (out == null && (out = MavenJDOMUtil.findChildValueByPath$default(cfg, "defaultOutputDirectory", null, 4, null)) == null) {
                    return $this$getAnnotationProcessorDirectory.getBuildDirectory() + (testSources ? "/generated-sources/apt-test" : "/generated-sources/apt");
                }
                if (!new File((String)out).isAbsolute()) {
                    out = $this$getAnnotationProcessorDirectory.getDirectory() + "/" + (String)out;
                }
                return out;
            }
        }
        String def = $this$getAnnotationProcessorDirectory.getGeneratedSourcesDirectory(testSources) + (testSources ? "/test-annotations" : "/annotations");
        String string = MavenJDOMUtil.findChildValueByPath(this.getCompilerConfig($this$getAnnotationProcessorDirectory), testSources ? "generatedTestSourcesDirectory" : "generatedSourcesDirectory", def);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final Element getCompilerConfig(MavenProject $this$compilerConfig) {
        Element executionConfiguration = this.getPluginExecutionConfiguration($this$compilerConfig, COMPILER_PLUGIN_GROUP_ID, COMPILER_PLUGIN_ARTIFACT_ID, EXECUTION_COMPILE);
        if (executionConfiguration != null) {
            return executionConfiguration;
        }
        return $this$compilerConfig.getPluginConfiguration(COMPILER_PLUGIN_GROUP_ID, COMPILER_PLUGIN_ARTIFACT_ID);
    }

    @Nullable
    public final MavenPlugin findCompilerPlugin$intellij_maven(@NotNull MavenProject $this$findCompilerPlugin) {
        Intrinsics.checkNotNullParameter((Object)$this$findCompilerPlugin, (String)"<this>");
        return MavenProject.findPlugin$default($this$findCompilerPlugin, COMPILER_PLUGIN_GROUP_ID, COMPILER_PLUGIN_ARTIFACT_ID, false, 4, null);
    }

    @NotNull
    public final String guessExistingEmbedderDir$intellij_maven(@NotNull Project project, @NotNull String multiModuleProjectDirectory) {
        Path originalPath;
        Path path;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)multiModuleProjectDirectory, (String)"multiModuleProjectDirectory");
        String dir = multiModuleProjectDirectory;
        if (StringsKt.isBlank((CharSequence)dir)) {
            MavenLog.LOG.warn("Maven project directory is blank. Using project base path");
            dir = project.getBasePath();
        }
        if (dir == null || StringsKt.isBlank((CharSequence)dir)) {
            MavenLog.LOG.warn("Maven project directory is blank. Using tmp dir");
            dir = System.getProperty("java.io.tmpdir");
        }
        for (path = originalPath = Path.of(dir, new String[0]).toAbsolutePath(); path != null && !Files.exists(path, new LinkOption[0]); path = path.getParent()) {
            String string = "Maven project %s directory does not exist. Using parent";
            Object[] objectArray = new Object[]{path};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            MavenLog.LOG.warn(string2);
        }
        if (path == null) {
            MavenLog.LOG.warn("Could not determine maven project directory: " + multiModuleProjectDirectory);
            return ((Object)originalPath).toString();
        }
        return ((Object)path).toString();
    }

    @NotNull
    public final MavenServerSettings convertSettings$intellij_maven(@NotNull Project project, @NotNull MavenGeneralSettings settings, @NotNull MavenDistribution mavenDistribution) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
        RemotePathTransformerFactory.Transformer transformer = RemotePathTransformerFactory.createForProject(project);
        MavenServerSettings result2 = new MavenServerSettings();
        result2.setLoggingLevel(settings.getOutputLevel().getLevel());
        result2.setOffline(settings.isWorkOffline());
        result2.setUpdateSnapshots(settings.isAlwaysUpdateSnapshots());
        String remotePath = transformer.toRemotePath(((Object)mavenDistribution.getMavenHome()).toString());
        result2.setMavenHomePath(remotePath);
        Path userSettings = MavenEelUtil.getUserSettings(project, settings.getUserSettingsFile(), settings.getMavenConfig());
        String userSettingsPath = ((Object)userSettings.toAbsolutePath()).toString();
        result2.setUserSettingsPath(transformer.toRemotePath(userSettingsPath));
        String localRepository = ((Object)MavenEelUtil.getLocalRepo(project, settings.getLocalRepository(), new MavenInSpecificPath(mavenDistribution.getMavenHome()), settings.getUserSettingsFile(), settings.getMavenConfig()).toAbsolutePath()).toString();
        result2.setLocalRepositoryPath(transformer.toRemotePath(localRepository));
        Path path = this.getGlobalConfigFromMavenConfig(settings);
        if (path == null) {
            path = MavenUtil.INSTANCE.resolveGlobalSettingsFile(mavenDistribution.getMavenHome());
        }
        Path file2 = path;
        result2.setGlobalSettingsPath(transformer.toRemotePath(((Object)file2.toAbsolutePath()).toString()));
        String sdkPath = MavenUtil.INSTANCE.getSdkPath(ProjectRootManager.getInstance((Project)project).getProjectSdk());
        if (sdkPath != null) {
            sdkPath = transformer.toRemotePath(sdkPath);
        }
        result2.setProjectJdk(sdkPath);
        return result2;
    }

    private final Path getGlobalConfigFromMavenConfig(MavenGeneralSettings settings) {
        MavenConfig mavenConfig = settings.getMavenConfig();
        if (mavenConfig == null) {
            return null;
        }
        MavenConfig mavenConfig2 = mavenConfig;
        String string = mavenConfig2.getFilePath(MavenConfigSettings.ALTERNATE_GLOBAL_SETTINGS);
        if (string == null) {
            return null;
        }
        String filePath = string;
        return Path.of(filePath, new String[0]);
    }

    private static final boolean getModuleEntities$lambda$0(Path $pomXmlPath, ModuleEntity it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = ModuleExtensions.getExModuleOptions((ModuleEntity)it);
        return Intrinsics.areEqual((Object)(object != null && (object = object.getLinkedProjectId()) != null ? NioPathUtil.toNioPathOrNull((String)object) : null), (Object)$pomXmlPath);
    }

    private static final Module createPreviewModule$lambda$0(VirtualFile $contentRoot, Project $project) {
        Path modulePath = $contentRoot.toNioPath().resolve($project.getName() + ".iml");
        ModuleManager moduleManager = ModuleManager.Companion.getInstance($project);
        Intrinsics.checkNotNull((Object)modulePath);
        String string = ModuleTypeManager.getInstance().getDefaultModuleType().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        Module module = moduleManager.newModule(modulePath, string);
        ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        Intrinsics.checkNotNullExpressionValue((Object)modifiableRootModel, (String)"getModifiableModel(...)");
        ModifiableRootModel modifiableModel = modifiableRootModel;
        modifiableModel.addContentEntry($contentRoot);
        modifiableModel.commit();
        ExternalSystemUtil.markModuleAsMaven((Module)module, null, (boolean)true);
        return module;
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"JDK_1_3", (Object)LanguageLevel.JDK_1_3), TuplesKt.to((Object)"JDK_1_4", (Object)LanguageLevel.JDK_1_4), TuplesKt.to((Object)"JDK_1_5", (Object)LanguageLevel.JDK_1_5), TuplesKt.to((Object)"JDK_1_6", (Object)LanguageLevel.JDK_1_6), TuplesKt.to((Object)"JDK_1_7", (Object)LanguageLevel.JDK_1_7)};
        MAVEN_IDEA_PLUGIN_LEVELS = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new String[]{MAIN_SUFFIX, TEST_SUFFIX};
        compileSourceRootEncoder = new PrefixStringEncoder(SetsKt.setOf((Object[])objectArray), "compileSourceRoot-");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenImportUtil$MavenLanguageLevelFinder;", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "isSource", "", "isTest", "executionId", "", "<init>", "(Lorg/jetbrains/idea/maven/project/MavenProject;ZZLjava/lang/String;)V", "getMavenProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "()Z", "getExecutionId", "()Ljava/lang/String;", "getMavenLanguageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "useMaven4Sources", "getConfigs", "", "Lorg/jdom/Element;", "getCompilerLevel", "levelName", "doGetCompilerLevel", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenImportUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenImportUtil.kt\norg/jetbrains/idea/maven/importing/MavenImportUtil$MavenLanguageLevelFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,745:1\n774#2:746\n865#2,2:747\n774#2:749\n865#2,2:750\n774#2:752\n865#2,2:753\n1761#2,3:756\n774#2:759\n865#2,2:760\n1617#2,9:762\n1869#2:771\n1870#2:773\n1626#2:774\n774#2:775\n865#2,2:776\n1617#2,9:778\n1869#2:787\n1870#2:789\n1626#2:790\n1617#2,9:791\n1869#2:800\n1870#2:802\n1626#2:803\n1#3:755\n1#3:772\n1#3:788\n1#3:801\n*S KotlinDebug\n*F\n+ 1 MavenImportUtil.kt\norg/jetbrains/idea/maven/importing/MavenImportUtil$MavenLanguageLevelFinder\n*L\n211#1:746\n211#1:747,2\n212#1:749\n212#1:750,2\n213#1:752\n213#1:753,2\n226#1:756,3\n231#1:759\n231#1:760,2\n232#1:762,9\n232#1:771\n232#1:773\n232#1:774\n239#1:775\n239#1:776,2\n240#1:778,9\n240#1:787\n240#1:789\n240#1:790\n256#1:791,9\n256#1:800\n256#1:802\n256#1:803\n232#1:772\n240#1:788\n256#1:801\n*E\n"})
    private static final class MavenLanguageLevelFinder {
        @NotNull
        private final MavenProject mavenProject;
        private final boolean isSource;
        private final boolean isTest;
        @Nullable
        private final String executionId;

        public MavenLanguageLevelFinder(@NotNull MavenProject mavenProject, boolean isSource, boolean isTest, @Nullable String executionId) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            this.mavenProject = mavenProject;
            this.isSource = isSource;
            this.isTest = isTest;
            this.executionId = executionId;
        }

        public /* synthetic */ MavenLanguageLevelFinder(MavenProject mavenProject, boolean bl, boolean bl2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                string = null;
            }
            this(mavenProject, bl, bl2, string);
        }

        @NotNull
        public final MavenProject getMavenProject() {
            return this.mavenProject;
        }

        public final boolean isSource() {
            return this.isSource;
        }

        public final boolean isTest() {
            return this.isTest;
        }

        @Nullable
        public final String getExecutionId() {
            return this.executionId;
        }

        @Nullable
        public final LanguageLevel getMavenLanguageLevel() {
            Object resultMaven4Source;
            block6: {
                Object object;
                MavenSource it;
                Iterable $this$filterTo$iv$iv;
                String scope = this.isTest ? MavenImportUtil.TEST_SUFFIX : MavenImportUtil.MAIN_SUFFIX;
                Iterable $this$filter$iv = this.mavenProject.getMavenSources();
                boolean $i$f$filter = false;
                Object object2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (MavenSource)element$iv$iv;
                    boolean bl = false;
                    if (!(it.isFromSourceTag() && it.isEnabled())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (MavenSource)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getScope(), (Object)scope)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (MavenSource)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getLang() == null || Intrinsics.areEqual((Object)it.getLang(), (Object)"java"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                for (MavenSource it2 : (Iterable)((List)destination$iv$iv)) {
                    boolean bl = false;
                    object2 = it2.getTargetVersion();
                    if (object2 == null) continue;
                    object = object2;
                    break block6;
                }
                object = resultMaven4Source = null;
            }
            if (resultMaven4Source != null) {
                return LanguageLevel.Companion.parse(resultMaven4Source);
            }
            boolean useReleaseCompilerProp = INSTANCE.isReleaseCompilerProp(this.mavenProject);
            LanguageLevel releaseLevel = useReleaseCompilerProp ? this.getCompilerLevel("release") : null;
            LanguageLevel languageLevel = releaseLevel;
            if (languageLevel == null) {
                languageLevel = this.getCompilerLevel(this.isSource ? "source" : "target");
            }
            return languageLevel;
        }

        private final boolean useMaven4Sources(MavenProject mavenProject) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = mavenProject.getMavenSources();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        MavenSource it = (MavenSource)element$iv;
                        boolean bl2 = false;
                        if (!it.isFromSourceTag()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private final List<Element> getConfigs() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            if (this.executionId != null) {
                void $this$mapNotNullTo$iv$iv2;
                Object it;
                Iterable $this$filterTo$iv$iv2;
                Iterable $this$filter$iv = INSTANCE.compilerExecutions(this.mavenProject);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    it = (MavenPlugin.Execution)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getExecutionId(), (Object)this.executionId)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv2 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach = false;
                it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    Element it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = it.next();
                    boolean bl = false;
                    MavenPlugin.Execution it2 = (MavenPlugin.Execution)element$iv$iv;
                    boolean bl2 = false;
                    if (it2.getConfigurationElement() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            if (this.isTest) {
                return INSTANCE.getTestCompilerConfigs(this.mavenProject);
            }
            Set nonDefaultExecutions = CollectionsKt.toSet((Iterable)INSTANCE.getNonDefaultCompilerExecutions$intellij_maven(this.mavenProject));
            Iterable $this$filter$iv = INSTANCE.getCompilerExecutions(this.mavenProject);
            boolean $i$f$filter = false;
            Iterable destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv$iv;
                boolean bl = false;
                if (!(!nonDefaultExecutions.contains(it.getExecutionId()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv2;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Element it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                MavenPlugin.Execution it = (MavenPlugin.Execution)element$iv$iv;
                boolean bl4 = false;
                if (it.getConfigurationElement() == null) continue;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            return CollectionsKt.plus((Collection)((List)destination$iv$iv2), (Iterable)INSTANCE.getPluginConfig(this.mavenProject));
        }

        /*
         * WARNING - void declaration
         */
        private final LanguageLevel getCompilerLevel(String levelName) {
            if (this.isTest) {
                String string;
                String string2 = levelName;
                if (((CharSequence)string2).length() > 0) {
                    void it;
                    char c = string2.charAt(0);
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = false;
                    StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.titlecase((char)it));
                    String string3 = string2;
                    int n = 1;
                    String string4 = string3.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                    string = stringBuilder2.append(string4).toString();
                } else {
                    string = string2;
                }
                String testLevelName = MavenImportUtil.TEST_SUFFIX + string;
                LanguageLevel testLevel = this.doGetCompilerLevel(testLevelName);
                if (testLevel != null) {
                    return testLevel;
                }
            }
            return this.doGetCompilerLevel(levelName);
        }

        /*
         * WARNING - void declaration
         */
        private final LanguageLevel doGetCompilerLevel(String levelName) {
            void $this$mapNotNullTo$iv$iv;
            List<Element> configs = this.getConfigs();
            String fallbackProperty = "maven.compiler." + levelName;
            Iterable $this$mapNotNull$iv = configs;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LanguageLevel it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Element it = (Element)element$iv$iv;
                boolean bl2 = false;
                if (LanguageLevel.Companion.parse(MavenJDOMUtil.findChildValueByPath$default(it, levelName, null, 4, null)) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List levels = (List)destination$iv$iv;
            Iterable iterable2 = levels;
            Comparator comparator = Comparator.naturalOrder();
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"naturalOrder(...)");
            LanguageLevel languageLevel = (LanguageLevel)CollectionsKt.maxWithOrNull((Iterable)iterable2, comparator);
            String maxLevel = languageLevel != null && (languageLevel = languageLevel.toJavaVersion()) != null ? languageLevel.toFeatureString() : null;
            String string = maxLevel;
            if (string == null) {
                string = this.mavenProject.getProperties().getProperty(fallbackProperty);
            }
            String level = string;
            return LanguageLevel.Companion.parse(level);
        }
    }
}

