/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.syncAction;

import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.externalSystem.impl.workspaceModel.ExternalProjectEntityId;
import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlImplKt;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.model.GradleLightBuild;
import org.jetbrains.plugins.gradle.model.GradleLightProject;
import org.jetbrains.plugins.gradle.model.projectModel.GradleBuildEntityId;
import org.jetbrains.plugins.gradle.model.projectModel.GradleProjectEntityId;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000b\u001a\u0014\u0010\u0010\u001a\u00020\u0006*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u0006*\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0002H\u0000\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\f\u001a\u00020\r*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;", "getVirtualFileUrlManager", "(Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;)Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "virtualFileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "path", "Ljava/nio/file/Path;", "file", "Ljava/io/File;", "", "externalProjectEntityId", "Lcom/intellij/platform/externalSystem/impl/workspaceModel/ExternalProjectEntityId;", "getExternalProjectEntityId", "(Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;)Lcom/intellij/platform/externalSystem/impl/workspaceModel/ExternalProjectEntityId;", "buildUrl", "Lorg/jetbrains/plugins/gradle/model/GradleLightBuild;", "context", "buildEntityId", "Lorg/jetbrains/plugins/gradle/model/projectModel/GradleBuildEntityId;", "projectUrl", "Lorg/jetbrains/plugins/gradle/model/GradleLightProject;", "projectEntityId", "Lorg/jetbrains/plugins/gradle/model/projectModel/GradleProjectEntityId;", "intellij.gradle"})
public final class GradleSyncContributorUtilKt {
    @NotNull
    public static final VirtualFileUrlManager getVirtualFileUrlManager(@NotNull ProjectResolverContext $this$virtualFileUrlManager) {
        Intrinsics.checkNotNullParameter((Object)$this$virtualFileUrlManager, (String)"<this>");
        return WorkspaceModelKt.getWorkspaceModel((Project)$this$virtualFileUrlManager.getProject()).getVirtualFileUrlManager();
    }

    @NotNull
    public static final VirtualFileUrl virtualFileUrl(@NotNull ProjectResolverContext $this$virtualFileUrl, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$virtualFileUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return VirtualFileUrlImplKt.toVirtualFileUrl((Path)path, (VirtualFileUrlManager)GradleSyncContributorUtilKt.getVirtualFileUrlManager($this$virtualFileUrl));
    }

    @NotNull
    public static final VirtualFileUrl virtualFileUrl(@NotNull ProjectResolverContext $this$virtualFileUrl, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$virtualFileUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return GradleSyncContributorUtilKt.virtualFileUrl($this$virtualFileUrl, path);
    }

    @NotNull
    public static final VirtualFileUrl virtualFileUrl(@NotNull ProjectResolverContext $this$virtualFileUrl, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)$this$virtualFileUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = Path.of(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        return GradleSyncContributorUtilKt.virtualFileUrl($this$virtualFileUrl, path2);
    }

    @NotNull
    public static final ExternalProjectEntityId getExternalProjectEntityId(@NotNull ProjectResolverContext $this$externalProjectEntityId) {
        Intrinsics.checkNotNullParameter((Object)$this$externalProjectEntityId, (String)"<this>");
        String string = $this$externalProjectEntityId.getExternalProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalProjectPath(...)");
        return new ExternalProjectEntityId(string);
    }

    @NotNull
    public static final VirtualFileUrl buildUrl(@NotNull GradleLightBuild $this$buildUrl, @NotNull ProjectResolverContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$buildUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path buildRootPath = $this$buildUrl.getBuildIdentifier().getRootDir().toPath();
        Intrinsics.checkNotNull((Object)buildRootPath);
        return VirtualFileUrlImplKt.toVirtualFileUrl((Path)buildRootPath, (VirtualFileUrlManager)GradleSyncContributorUtilKt.getVirtualFileUrlManager(context));
    }

    @NotNull
    public static final GradleBuildEntityId buildEntityId(@NotNull GradleLightBuild $this$buildEntityId, @NotNull ProjectResolverContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$buildEntityId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new GradleBuildEntityId(GradleSyncContributorUtilKt.getExternalProjectEntityId(context), GradleSyncContributorUtilKt.buildUrl($this$buildEntityId, context));
    }

    @NotNull
    public static final VirtualFileUrl projectUrl(@NotNull GradleLightProject $this$projectUrl, @NotNull ProjectResolverContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$projectUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Path projectRootPath = $this$projectUrl.getProjectDirectory().toPath();
        Intrinsics.checkNotNull((Object)projectRootPath);
        return VirtualFileUrlImplKt.toVirtualFileUrl((Path)projectRootPath, (VirtualFileUrlManager)GradleSyncContributorUtilKt.getVirtualFileUrlManager(context));
    }

    @NotNull
    public static final GradleProjectEntityId projectEntityId(@NotNull GradleLightProject $this$projectEntityId, @NotNull ProjectResolverContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$projectEntityId, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        GradleLightBuild gradleLightBuild = $this$projectEntityId.getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)gradleLightBuild, (String)"getBuild(...)");
        return new GradleProjectEntityId(GradleSyncContributorUtilKt.buildEntityId(gradleLightBuild, context), GradleSyncContributorUtilKt.projectUrl($this$projectEntityId, context));
    }
}

