/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.training.ift.lesson.refactorings;

import com.intellij.java.ift.JavaLessonsBundle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.training.ift.KotlinLessonsBundle;
import training.dsl.LessonContext;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.dsl.LessonUtil;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.learn.lesson.general.refactorings.RefactoringMenuLessonBase;
import training.util.UtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000f\u001a\u00020\u000b*\u00020\nH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R%\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/training/ift/lesson/refactorings/KotlinRefactoringMenuLesson;", "Ltraining/learn/lesson/general/refactorings/RefactoringMenuLessonBase;", "<init>", "()V", "sample", "Ltraining/dsl/LessonSample;", "getSample", "()Ltraining/dsl/LessonSample;", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "moreRefactoringsTasks", "intellij.kotlin.featuresTrainer"})
public final class KotlinRefactoringMenuLesson
extends RefactoringMenuLessonBase {
    @NotNull
    private final LessonSample sample = LessonSampleKt.parseLessonSample((String)"import java.io.FileReader\nimport java.io.BufferedReader\n\nfun main() {\n    val list = readStrings()\n    val filtered = list.filter { it.isNotEmpty() }\n    filtered.forEach { \n        println(it)\n    }\n}\n\nfun readStrings(): List<String> {\n    return BufferedReader(<select>FileReader(\"input.txt\")</select>).readLines()\n}");
    @NotNull
    private final Function1<LessonContext, Unit> lessonContent = arg_0 -> KotlinRefactoringMenuLesson.lessonContent$lambda$0(this, arg_0);

    public KotlinRefactoringMenuLesson() {
        super("java.refactoring.menu");
    }

    @NotNull
    protected LessonSample getSample() {
        return this.sample;
    }

    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return this.lessonContent;
    }

    private final void moreRefactoringsTasks(LessonContext $this$moreRefactoringsTasks) {
        $this$moreRefactoringsTasks.waitBeforeContinue(300);
        String inlineVariableName = "list";
        LessonContext.caret$default((LessonContext)$this$moreRefactoringsTasks, (String)inlineVariableName, (boolean)false, (int)2, null);
        $this$moreRefactoringsTasks.actionTask("Inline", (arg_0, arg_1) -> KotlinRefactoringMenuLesson.moreRefactoringsTasks$lambda$0(inlineVariableName, arg_0, arg_1));
        $this$moreRefactoringsTasks.task(arg_0 -> KotlinRefactoringMenuLesson.moreRefactoringsTasks$lambda$1(inlineVariableName, arg_0));
        $this$moreRefactoringsTasks.caret("txt", true);
        $this$moreRefactoringsTasks.actionTask("IntroduceConstant", KotlinRefactoringMenuLesson::moreRefactoringsTasks$lambda$2);
        $this$moreRefactoringsTasks.actionTask("NextTemplateVariable", KotlinRefactoringMenuLesson::moreRefactoringsTasks$lambda$3);
    }

    private static final Unit lessonContent$lambda$0(KotlinRefactoringMenuLesson this$0, LessonContext lessonContext) {
        Intrinsics.checkNotNullParameter((Object)lessonContext, (String)"<this>");
        this$0.extractParameterTasks(lessonContext);
        this$0.moreRefactoringsTasks(lessonContext);
        LessonUtilKt.restoreRefactoringOptionsInformer((LessonContext)lessonContext);
        return Unit.INSTANCE;
    }

    private static final String moreRefactoringsTasks$lambda$0(String $inlineVariableName, TaskContext $this$actionTask, String it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LessonUtil.restoreIfModifiedOrMoved$default((LessonUtil)LessonUtil.INSTANCE, (TaskContext)$this$actionTask, null, (int)1, null);
        if (UtilsKt.getAdaptToNotNativeLocalization()) {
            Object[] objectArray = new Object[]{$this$actionTask.code($inlineVariableName), $this$actionTask.action("Refactorings.QuickListPopupAction"), $this$actionTask.strong(KotlinBundle.message((String)"title.inline.property", (Object[])new Object[0])), $this$actionTask.action(it)};
            string = JavaLessonsBundle.INSTANCE.message("java.refactoring.menu.inline.variable", objectArray);
        } else {
            Object[] objectArray = new Object[]{$this$actionTask.code($inlineVariableName), $this$actionTask.action("Refactorings.QuickListPopupAction"), $this$actionTask.action(it)};
            string = KotlinLessonsBundle.INSTANCE.message("kotlin.refactoring.menu.inline.property.eng", objectArray);
        }
        return string;
    }

    private static final Unit moreRefactoringsTasks$lambda$1(String $inlineVariableName, TaskContext $this$task) {
        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
        $this$task.stateCheck(arg_0 -> KotlinRefactoringMenuLesson.moreRefactoringsTasks$lambda$1$0($inlineVariableName, arg_0));
        return Unit.INSTANCE;
    }

    private static final boolean moreRefactoringsTasks$lambda$1$0(String $inlineVariableName, TaskRuntimeContext $this$stateCheck) {
        Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
        CharSequence charSequence = $this$stateCheck.getEditor().getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        return !StringsKt.contains$default((CharSequence)charSequence, (CharSequence)$inlineVariableName, (boolean)false, (int)2, null);
    }

    private static final String moreRefactoringsTasks$lambda$2(TaskContext $this$actionTask, String it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LessonUtil.restoreIfModifiedOrMoved$default((LessonUtil)LessonUtil.INSTANCE, (TaskContext)$this$actionTask, null, (int)1, null);
        if (UtilsKt.getAdaptToNotNativeLocalization()) {
            Object[] objectArray = new Object[]{$this$actionTask.action("Refactorings.QuickListPopupAction"), $this$actionTask.strong(LessonUtilKt.dropMnemonic((String)KotlinBundle.message((String)"introduce.constant", (Object[])new Object[0]))), $this$actionTask.action(it)};
            string = JavaLessonsBundle.INSTANCE.message("java.refactoring.menu.introduce.constant", objectArray);
        } else {
            Object[] objectArray = new Object[]{$this$actionTask.action("Refactorings.QuickListPopupAction"), $this$actionTask.action(it)};
            string = JavaLessonsBundle.INSTANCE.message("java.refactoring.menu.introduce.constant.eng", objectArray);
        }
        return string;
    }

    private static final String moreRefactoringsTasks$lambda$3(TaskContext $this$actionTask, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$actionTask, (String)"$this$actionTask");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[]{LessonUtil.INSTANCE.rawEnter()};
        return KotlinLessonsBundle.INSTANCE.message("kotlin.refactoring.menu.confirm.constant", objectArray);
    }
}

