/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightReceiverUsagesHandler;
import org.jetbrains.kotlin.idea.highlighter.ReceiverInfo;
import org.jetbrains.kotlin.idea.highlighter.ReceiverInfoSearcher;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/HighlightReceiverUsagesIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "isApplicableTo", "", "element", "findReceiverInfo", "Lorg/jetbrains/kotlin/idea/highlighter/ReceiverInfo;", "startInWriteAction", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
public final class HighlightReceiverUsagesIntention
extends SelfTargetingOffsetIndependentIntention<KtElement>
implements LowPriorityAction {
    public HighlightReceiverUsagesIntention() {
        super(KtElement.class, KotlinBundle.messagePointer((String)"highlight.usages.of.receiver", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.findReceiverInfo(element) != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ReceiverInfo findReceiverInfo(KtElement element) {
        ReceiverInfo receiverInfo;
        if (element instanceof KtReferenceExpression) {
            PsiElement psiElement = ((KtReferenceExpression)element).getFirstChild();
            if (Intrinsics.areEqual((Object)(psiElement != null ? PsiTreeUtilKt.getElementType((PsiElement)psiElement) : null), (Object)KtTokens.THIS_KEYWORD)) {
                PsiElement psiElement2 = ((KtReferenceExpression)element).getFirstChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getFirstChild(...)");
                receiverInfo = ReceiverInfoSearcher.INSTANCE.findReceiverInfoForUsageHighlighting(psiElement2);
                return receiverInfo;
            }
        }
        receiverInfo = ReceiverInfoSearcher.INSTANCE.findReceiverInfoForUsageHighlighting((PsiElement)element);
        return receiverInfo;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    public void applyTo(@NotNull KtElement element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (editor == null) {
            return;
        }
        ApplicationKt.getApplication().executeOnPooledThread(() -> HighlightReceiverUsagesIntention.applyTo$lambda$0(this, element, editor));
    }

    private static final void applyTo$lambda$0(HighlightReceiverUsagesIntention this$0, KtElement $element, Editor $editor) {
        ReadAction.computeCancellable(() -> HighlightReceiverUsagesIntention.applyTo$lambda$0$0(this$0, $element, $editor));
    }

    private static final Unit applyTo$lambda$0$0(HighlightReceiverUsagesIntention this$0, KtElement $element, Editor $editor) {
        ReceiverInfo receiverInfo = this$0.findReceiverInfo($element);
        if (receiverInfo == null) {
            return Unit.INSTANCE;
        }
        ReceiverInfo info2 = receiverInfo;
        new KotlinHighlightReceiverUsagesHandler(info2, $editor, false).highlightUsages();
        return Unit.INSTANCE;
    }
}

