/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.imports;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/imports/PseudoCommonSourceSetUtils;", "", "<init>", "()V", "PSEUDO_COMMON_SOURCE_SET_MARKER_FILE", "", "inPseudoCommonSourceSet", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "PLATFORM_SPECIFIC_IMPORTS", "", "Lorg/jetbrains/kotlin/resolve/ImportPath;", "getPLATFORM_SPECIFIC_IMPORTS", "()Ljava/util/Set;", "intellij.kotlin.codeInsight.shared"})
public final class PseudoCommonSourceSetUtils {
    @NotNull
    public static final PseudoCommonSourceSetUtils INSTANCE = new PseudoCommonSourceSetUtils();
    @NotNull
    private static final String PSEUDO_COMMON_SOURCE_SET_MARKER_FILE = ".pseudoCommonKotlinSourceSet";
    @NotNull
    private static final Set<ImportPath> PLATFORM_SPECIFIC_IMPORTS = SetsKt.setOf((Object)ImportPath.Companion.fromString("kotlin.jvm.*"));

    private PseudoCommonSourceSetUtils() {
    }

    public final boolean inPseudoCommonSourceSet(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile virtualFile2 = ProjectRootsUtilKt.getSourceRoot(virtualFile, project);
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile sourceRoot = virtualFile2;
        return sourceRoot.findChild(PSEUDO_COMMON_SOURCE_SET_MARKER_FILE) != null;
    }

    @NotNull
    public final Set<ImportPath> getPLATFORM_SPECIFIC_IMPORTS() {
        return PLATFORM_SPECIFIC_IMPORTS;
    }
}

