/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.base.facet.KotlinBaseFacetBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u001a\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\nH\u0016J2\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00132\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u001eH\u0016J\u0014\u0010\u001f\u001a\u00020\u00132\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\nH\u0016\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/idea/framework/KotlinSdkType;", "Lcom/intellij/openapi/projectRoots/SdkType;", "<init>", "()V", "getPresentableName", "", "getIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "isValidSdkHome", "", "path", "suggestSdkName", "currentSdkName", "sdkHome", "suggestHomePath", "", "sdkHasValidPath", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "getVersionString", "supportsCustomCreateUI", "showCustomCreateUI", "", "sdkModel", "Lcom/intellij/openapi/projectRoots/SdkModel;", "parentComponent", "Ljavax/swing/JComponent;", "selectedSdk", "sdkCreatedCallback", "Ljava/util/function/Consumer;", "createSdkWithUniqueName", "existingSdks", "", "createAdditionalDataConfigurable", "sdkModificator", "Lcom/intellij/openapi/projectRoots/SdkModificator;", "saveAdditionalData", "additionalData", "Lcom/intellij/openapi/projectRoots/SdkAdditionalData;", "additional", "Lorg/jdom/Element;", "allowCreationByUser", "Companion", "intellij.kotlin.base.facet"})
public final class KotlinSdkType
extends SdkType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final KotlinSdkType INSTANCE = new KotlinSdkType();

    public KotlinSdkType() {
        super("KotlinSDK");
    }

    @NotNull
    public String getPresentableName() {
        return KotlinBaseFacetBundle.message("framework.name.kotlin.sdk", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = KotlinIcons.SMALL_LOGO;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"SMALL_LOGO");
        return icon2;
    }

    public boolean isValidSdkHome(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return true;
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, @NotNull String sdkHome) {
        Intrinsics.checkNotNullParameter((Object)sdkHome, (String)"sdkHome");
        return "Kotlin SDK";
    }

    @Nullable
    public Void suggestHomePath() {
        return null;
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        return true;
    }

    @NotNull
    public String getVersionString(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        return KotlinPluginLayout.getStandaloneCompilerVersion().getRawVersion();
    }

    public boolean supportsCustomCreateUI() {
        return true;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<? super Sdk> sdkCreatedCallback) {
        Intrinsics.checkNotNullParameter((Object)sdkModel, (String)"sdkModel");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        Intrinsics.checkNotNullParameter(sdkCreatedCallback, (String)"sdkCreatedCallback");
        Sdk[] sdkArray = sdkModel.getSdks();
        Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getSdks(...)");
        sdkCreatedCallback.accept((Sdk)this.createSdkWithUniqueName(ArraysKt.toList((Object[])sdkArray)));
    }

    @NotNull
    public final Sdk createSdkWithUniqueName(@NotNull Collection<? extends Sdk> existingSdks) {
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        String sdkName = this.suggestSdkName(SdkConfigurationUtil.createUniqueSdkName((SdkType)this, (String)"", existingSdks), "");
        Sdk sdk2 = ProjectJdkTable.getInstance().createSdk(sdkName, (SdkTypeId)this);
        Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"createSdk(...)");
        return sdk2;
    }

    @Nullable
    public Void createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        Intrinsics.checkNotNullParameter((Object)sdkModel, (String)"sdkModel");
        Intrinsics.checkNotNullParameter((Object)sdkModificator, (String)"sdkModificator");
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        Intrinsics.checkNotNullParameter((Object)additionalData, (String)"additionalData");
        Intrinsics.checkNotNullParameter((Object)additional, (String)"additional");
    }

    public boolean allowCreationByUser() {
        return false;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\b\u0010\r\u001a\u00020\u0007H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/framework/KotlinSdkType$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/jetbrains/kotlin/idea/framework/KotlinSdkType;", "setUpIfNeeded", "", "disposable", "Lcom/intellij/openapi/Disposable;", "checkIfNeeded", "Lkotlin/Function0;", "", "removeKotlinSdkInTests", "intellij.kotlin.base.facet"})
    @SourceDebugExtension(value={"SMAP\nKotlinSdkType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSdkType.kt\norg/jetbrains/kotlin/idea/framework/KotlinSdkType$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,90:1\n12970#2,2:91\n12970#2,2:93\n3919#2:95\n4434#2,2:96\n*S KotlinDebug\n*F\n+ 1 KotlinSdkType.kt\norg/jetbrains/kotlin/idea/framework/KotlinSdkType$Companion\n*L\n27#1:91,2\n36#1:93,2\n51#1:95\n51#1:96,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        public final void setUpIfNeeded(@Nullable Disposable disposable, @NotNull Function0<Boolean> checkIfNeeded) {
            boolean bl;
            Object[] projectSdks;
            block3: {
                Intrinsics.checkNotNullParameter(checkIfNeeded, (String)"checkIfNeeded");
                Object[] objectArray = ProjectJdkTable.getInstance().getAllJdks();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getAllJdks(...)");
                Object[] $this$any$iv = projectSdks = objectArray;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int j = 0; j < n; ++j) {
                    Sdk element$iv;
                    Sdk it = element$iv = $this$any$iv[j];
                    boolean bl2 = false;
                    if (!(it.getSdkType() instanceof KotlinSdkType)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
            if (!((Boolean)checkIfNeeded.invoke()).booleanValue()) {
                return;
            }
            String string = SdkConfigurationUtil.createUniqueSdkName((SdkType)INSTANCE, (String)"", (Collection)ArraysKt.toList((Object[])projectSdks));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"createUniqueSdkName(...)");
            String newSdkName = string;
            Sdk sdk2 = ProjectJdkTable.getInstance().createSdk(newSdkName, (SdkTypeId)INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)sdk2, (String)"createSdk(...)");
            Sdk newJdk = sdk2;
            INSTANCE.setupSdkPaths(newJdk);
            ApplicationManager.getApplication().invokeAndWait(() -> Companion.setUpIfNeeded$lambda$2(disposable, newJdk));
        }

        public static /* synthetic */ void setUpIfNeeded$default(Companion companion, Disposable disposable, Function0 function0, int n, Object object) {
            if ((n & 1) != 0) {
                disposable = null;
            }
            if ((n & 2) != 0) {
                function0 = Companion::setUpIfNeeded$lambda$0;
            }
            companion.setUpIfNeeded(disposable, (Function0<Boolean>)function0);
        }

        @TestOnly
        public final void removeKotlinSdkInTests() {
            ActionsKt.invokeAndWaitIfNeeded$default(null, Companion::removeKotlinSdkInTests$lambda$0, (int)1, null);
        }

        @JvmOverloads
        public final void setUpIfNeeded(@Nullable Disposable disposable) {
            org.jetbrains.kotlin.idea.framework.KotlinSdkType$Companion.setUpIfNeeded$default(this, disposable, null, 2, null);
        }

        @JvmOverloads
        public final void setUpIfNeeded() {
            org.jetbrains.kotlin.idea.framework.KotlinSdkType$Companion.setUpIfNeeded$default(this, null, null, 3, null);
        }

        private static final boolean setUpIfNeeded$lambda$0() {
            return true;
        }

        private static final void setUpIfNeeded$lambda$2(Disposable $disposable, Sdk $newJdk) {
            ActionsKt.runWriteAction(() -> Companion.setUpIfNeeded$lambda$2$0($disposable, $newJdk));
        }

        private static final Unit setUpIfNeeded$lambda$2$0(Disposable $disposable, Sdk $newJdk) {
            boolean bl;
            block4: {
                Sdk[] sdkArray = ProjectJdkTable.getInstance().getAllJdks();
                Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getAllJdks(...)");
                Object[] $this$any$iv = sdkArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Sdk it = (Sdk)element$iv;
                    boolean bl2 = false;
                    if (!(it.getSdkType() instanceof KotlinSdkType)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) {
                return Unit.INSTANCE;
            }
            if ($disposable != null) {
                ProjectJdkTable.getInstance().addJdk($newJdk, $disposable);
            } else {
                ProjectJdkTable.getInstance().addJdk($newJdk);
            }
            return Unit.INSTANCE;
        }

        private static final Unit removeKotlinSdkInTests$lambda$0() {
            ActionsKt.runWriteAction(Companion::removeKotlinSdkInTests$lambda$0$0);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit removeKotlinSdkInTests$lambda$0$0() {
            void $this$filterTo$iv$iv;
            ProjectJdkTable sdkTable = ProjectJdkTable.getInstance();
            Sdk[] sdkArray = sdkTable.getAllJdks();
            Intrinsics.checkNotNullExpressionValue((Object)sdkArray, (String)"getAllJdks(...)");
            Object[] $this$filter$iv = sdkArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Sdk it = (Sdk)element$iv$iv;
                boolean bl = false;
                if (!(it.getSdkType() instanceof KotlinSdkType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List kotlinSdks = (List)destination$iv$iv;
            for (Sdk kotlinSdk : kotlinSdks) {
                sdkTable.removeJdk(kotlinSdk);
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

