/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.base.fe10.analysis.decompiler.ByDescriptorIndexer;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleInfoProviderUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.RootKindFilter;
import org.jetbrains.kotlin.idea.base.projectStructure.SourceKindFilterUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.BinaryModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibrarySourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.SourceForBinaryModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfoUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptDependenciesInfo;
import org.jetbrains.kotlin.idea.decompiler.navigation.MemberMatching;
import org.jetbrains.kotlin.idea.decompiler.navigation.SourceNavigationHelperKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinStringStubIndexHelper;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.CollectionUtilsKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002;<B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\r*\u00020\u0019H\u0002J\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\r*\u00020\u0019H\u0002J\u0018\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\b\u0012\u0004\u0012\u00020\u000e0\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cH\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010!2\u0006\u0010\u0014\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J7\u0010'\u001a\u0004\u0018\u0001H(\"\b\b\u0000\u0010(*\u00020!2\u0006\u0010)\u001a\u0002H(2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H(0+H\u0002\u00a2\u0006\u0002\u0010,J\u001a\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020.2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00020!0\u001c2\u0006\u0010\u0014\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J.\u00101\u001a\b\u0012\u0004\u0012\u00020!0\r2\u0006\u00102\u001a\u00020.2\u0006\u00103\u001a\u00020#2\u000e\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020!05H\u0002J\u000e\u00106\u001a\u0002072\u0006\u0010\u0014\u001a\u000207J\u000e\u00108\u001a\u0002072\u0006\u0010\u0014\u001a\u000207J\u0018\u00109\u001a\u0002072\u0006\u0010:\u001a\u0002072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "forceResolve", "", "resetForceResolve", "", "setForceResolve", "targetClassFilesToSourcesScopes", "", "Lcom/intellij/psi/search/GlobalSearchScope;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "targetScopes", "declaration", "Lorg/jetbrains/kotlin/psi/KtElement;", "navigationKind", "Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "associatedCommonLibraries", "Lorg/jetbrains/kotlin/idea/base/projectStructure/moduleInfo/BinaryModuleInfo;", "sourcesOnlyDependencies", "union", "", "haveRenamesInImports", "files", "Lorg/jetbrains/kotlin/psi/KtFile;", "findSpecialProperty", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "memberName", "Lorg/jetbrains/kotlin/name/Name;", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "convertPropertyOrFunction", "findFirstMatchingInIndex", "T", "entity", "helper", "Lorg/jetbrains/kotlin/idea/stubindex/KotlinStringStubIndexHelper;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;Lorg/jetbrains/kotlin/idea/stubindex/KotlinStringStubIndexHelper;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "findClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "decompiledClassOrObject", "getInitialTopLevelCandidates", "getInitialMemberCandidates", "sourceClassOrObject", "name", "declarationClass", "Ljava/lang/Class;", "getNavigationElement", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getOriginalElement", "navigateToDeclaration", "from", "NavigationKind", "SourceAndDecompiledConversionVisitor", "kotlin.base.fe10.analysis"})
@SourceDebugExtension(value={"SMAP\nSourceNavigationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceNavigationHelper.kt\norg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n1617#2,9:353\n1869#2:362\n1870#2:364\n1626#2:365\n1374#2:366\n1460#2,5:367\n1617#2,9:372\n1869#2:381\n1870#2:383\n1626#2:384\n1761#2,3:385\n1761#2,3:388\n774#2:391\n865#2,2:392\n774#2:394\n865#2,2:395\n295#2,2:397\n1374#2:399\n1460#2,5:400\n1#3:363\n1#3:382\n*S KotlinDebug\n*F\n+ 1 SourceNavigationHelper.kt\norg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper\n*L\n71#1:353,9\n71#1:362\n71#1:364\n71#1:365\n72#1:366\n72#1:367,5\n74#1:372,9\n74#1:381\n74#1:383\n74#1:384\n76#1:385,3\n136#1:388,3\n207#1:391\n207#1:392,2\n216#1:394\n216#1:395,2\n248#1:397,2\n269#1:399\n269#1:400,5\n71#1:363\n74#1:382\n*E\n"})
public final class SourceNavigationHelper {
    @NotNull
    public static final SourceNavigationHelper INSTANCE = new SourceNavigationHelper();
    @NotNull
    private static final Logger LOG;
    private static boolean forceResolve;

    private SourceNavigationHelper() {
    }

    @TestOnly
    public final void resetForceResolve() {
        forceResolve = false;
    }

    @TestOnly
    public final void setForceResolve(boolean forceResolve) {
        SourceNavigationHelper.forceResolve = forceResolve;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GlobalSearchScope> targetClassFilesToSourcesScopes(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        boolean bl;
        List<GlobalSearchScope> additionalScope;
        List<GlobalSearchScope> primaryScope;
        block6: {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv2;
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List binaryModuleInfos = SequencesKt.toList(ModuleInfoProviderUtils.collectLibraryBinariesModuleInfos(ModuleInfoProvider.Companion.getInstance(project), virtualFile));
            Iterable iterable = binaryModuleInfos;
            SourceNavigationHelper sourceNavigationHelper = this;
            boolean $i$f$mapNotNull22 = false;
            void var7_8 = $this$mapNotNull$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                GlobalSearchScope it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                BinaryModuleInfo it = (BinaryModuleInfo)element$iv$iv;
                boolean bl3 = false;
                SourceForBinaryModuleInfo sourceForBinaryModuleInfo = it.getSourcesModuleInfo();
                if ((sourceForBinaryModuleInfo != null ? sourceForBinaryModuleInfo.sourceScope() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            primaryScope = sourceNavigationHelper.union((List)destination$iv$iv);
            Iterable $i$f$mapNotNull22 = binaryModuleInfos;
            sourceNavigationHelper = this;
            boolean $i$f$flatMap = false;
            destination$iv$iv = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BinaryModuleInfo it = (BinaryModuleInfo)element$iv$iv;
                boolean bl5 = false;
                Iterable list$iv$iv = CollectionsKt.plus((Collection)INSTANCE.associatedCommonLibraries(it), (Iterable)INSTANCE.sourcesOnlyDependencies(it));
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv2;
            boolean $i$f$mapNotNull = false;
            $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator3.hasNext()) {
                GlobalSearchScope it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator3.next();
                boolean bl6 = false;
                BinaryModuleInfo it = (BinaryModuleInfo)element$iv$iv;
                boolean bl7 = false;
                SourceForBinaryModuleInfo sourceForBinaryModuleInfo = it.getSourcesModuleInfo();
                if ((sourceForBinaryModuleInfo != null ? sourceForBinaryModuleInfo.sourceScope() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl8 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            additionalScope = sourceNavigationHelper.union((List)destination$iv$iv2);
            Iterable $this$any$iv = binaryModuleInfos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BinaryModuleInfo it = (BinaryModuleInfo)element$iv;
                    boolean bl9 = false;
                    if (!(it instanceof ScriptDependenciesInfo)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl ? CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)primaryScope, (Iterable)additionalScope), (Object)ProjectScope.getContentScope((Project)project)) : CollectionsKt.plus((Collection)primaryScope, (Iterable)additionalScope);
    }

    private final List<GlobalSearchScope> targetScopes(KtElement declaration, NavigationKind navigationKind) {
        List<GlobalSearchScope> list2;
        KtFile ktFile2 = declaration.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile containingFile = ktFile2;
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile vFile = virtualFile;
        Project project = declaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        switch (WhenMappings.$EnumSwitchMapping$0[navigationKind.ordinal()]) {
            case 1: {
                list2 = this.targetClassFilesToSourcesScopes(vFile, project2);
                break;
            }
            case 2: {
                KtLightClass psiClass;
                if (JvmFileClassUtilKt.getFileClassInfo((KtFile)containingFile) instanceof JvmMultifileClassPartInfo && (psiClass = LightClassUtilsKt.findFacadeClass((KtFile)containingFile)) != null) {
                    ModuleInfoProvider moduleInfoProvider = ModuleInfoProvider.Companion.getInstance(project2);
                    VirtualFile virtualFile2 = psiClass.getContainingFile().getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getVirtualFile(...)");
                    return this.union(SequencesKt.toSet((Sequence)SequencesKt.map(ModuleInfoProviderUtils.collectLibraryBinariesModuleInfos(moduleInfoProvider, virtualFile2), SourceNavigationHelper::targetScopes$lambda$0)));
                }
                list2 = this.union(SequencesKt.toList((Sequence)SequencesKt.map(ModuleInfoProviderUtils.collectLibrarySourcesModuleInfos(ModuleInfoProvider.Companion.getInstance(project2), vFile), SourceNavigationHelper::targetScopes$lambda$1)));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list2;
    }

    private final List<BinaryModuleInfo> associatedCommonLibraries(BinaryModuleInfo $this$associatedCommonLibraries) {
        if (TargetPlatformKt.isCommon((TargetPlatform)$this$associatedCommonLibraries.getPlatform())) {
            return CollectionsKt.emptyList();
        }
        SmartList result2 = new SmartList();
        List<IdeaModuleInfo> dependencies = $this$associatedCommonLibraries.dependencies();
        for (IdeaModuleInfo ideaModuleInfo : dependencies) {
            if (!(ideaModuleInfo instanceof BinaryModuleInfo) || !TargetPlatformKt.isCommon((TargetPlatform)ideaModuleInfo.getPlatform())) continue;
            ((Collection)result2).add(ideaModuleInfo);
        }
        return (List)result2;
    }

    private final List<BinaryModuleInfo> sourcesOnlyDependencies(BinaryModuleInfo $this$sourcesOnlyDependencies) {
        if (!($this$sourcesOnlyDependencies instanceof LibraryInfo)) {
            return CollectionsKt.emptyList();
        }
        return LibraryDependenciesCache.Companion.getInstance(((LibraryInfo)$this$sourcesOnlyDependencies).getProject()).getLibraryDependencies((LibraryInfo)$this$sourcesOnlyDependencies).getSourcesOnlyDependencies();
    }

    private final List<GlobalSearchScope> union(Collection<? extends GlobalSearchScope> $this$union) {
        return !$this$union.isEmpty() ? CollectionsKt.listOf((Object)GlobalSearchScope.union($this$union)) : CollectionsKt.emptyList();
    }

    private final boolean haveRenamesInImports(Collection<? extends KtFile> files) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = files;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtFile p0 = (KtFile)element$iv;
                    boolean bl2 = false;
                    if (!p0.hasImportAlias()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final KtNamedDeclaration findSpecialProperty(Name memberName, KtClass containingClass) {
        List constructorParameters = containingClass.getPrimaryConstructorParameters();
        for (KtParameter constructorParameter : constructorParameters) {
            if (!Intrinsics.areEqual((Object)memberName, (Object)constructorParameter.getNameAsName()) || !constructorParameter.hasValOrVar()) continue;
            return (KtNamedDeclaration)constructorParameter;
        }
        if (containingClass.hasModifier(KtTokens.ENUM_KEYWORD)) {
            for (KtDeclaration declaration : containingClass.getDeclarations()) {
                if (!(declaration instanceof KtEnumEntry) || !Intrinsics.areEqual((Object)((KtEnumEntry)declaration).getNameAsSafeName(), (Object)memberName)) continue;
                return (KtNamedDeclaration)declaration;
            }
        }
        return null;
    }

    private final KtNamedDeclaration convertPropertyOrFunction(KtNamedDeclaration declaration, NavigationKind navigationKind) {
        Object sourceClassOrObject;
        if (declaration instanceof KtPrimaryConstructor) {
            KtClassOrObject sourceClassOrObject2 = this.findClassOrObject(((KtPrimaryConstructor)declaration).getContainingClassOrObject(), navigationKind);
            KtClassOrObject ktClassOrObject = sourceClassOrObject2;
            return ktClassOrObject != null && (ktClassOrObject = ktClassOrObject.getPrimaryConstructor()) != null ? (KtNamedDeclaration)ktClassOrObject : (KtNamedDeclaration)sourceClassOrObject2;
        }
        String string = declaration.getName();
        if (string == null) {
            SourceNavigationHelper $this$convertPropertyOrFunction_u24lambda_u240 = this;
            boolean bl = false;
            LOG.debug("Declaration with null name:" + DebugTextUtilKt.getDebugText((KtElement)((KtElement)declaration)));
            return null;
        }
        String memberNameAsString = string;
        Name name2 = Name.identifier((String)memberNameAsString);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        Name memberName = name2;
        PsiElement decompiledContainer = declaration.getParent();
        Collection candidates2 = null;
        PsiElement bl = decompiledContainer;
        if (bl instanceof KtFile) {
            candidates2 = this.getInitialTopLevelCandidates(declaration, navigationKind);
        } else if (bl instanceof KtClassBody) {
            List<KtNamedDeclaration> list2;
            List<KtNamedDeclaration> list3;
            PsiElement psiElement = ((KtClassBody)decompiledContainer).getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            KtClassOrObject decompiledClassOrObject = (KtClassOrObject)psiElement;
            KtClassOrObject ktClassOrObject = sourceClassOrObject = this.findClassOrObject(decompiledClassOrObject, navigationKind);
            if (ktClassOrObject != null) {
                KtClassOrObject it = ktClassOrObject;
                boolean bl2 = false;
                list3 = INSTANCE.getInitialMemberCandidates((KtClassOrObject)sourceClassOrObject, memberName, (Class<? extends KtNamedDeclaration>)declaration.getClass());
            } else {
                list3 = list2 = null;
            }
            if (list3 == null) {
                list2 = CollectionsKt.emptyList();
            }
            if (((List)(candidates2 = (Collection)list2)).isEmpty() && declaration instanceof KtProperty && sourceClassOrObject instanceof KtClass) {
                return this.findSpecialProperty(memberName, (KtClass)sourceClassOrObject);
            }
        } else {
            throw new KotlinExceptionWithAttachments("Unexpected container of " + (navigationKind == NavigationKind.CLASS_FILES_TO_SOURCES ? "decompiled" : "source") + " declaration: " + decompiledContainer.getClass().getSimpleName()).withPsiAttachment("declaration", (PsiElement)declaration).withPsiAttachment("container", decompiledContainer).withPsiAttachment("file", (PsiElement)declaration.getContainingFile());
        }
        if (candidates2.isEmpty()) {
            return null;
        }
        if (!forceResolve) {
            KtNamedDeclaration it;
            Iterable $this$filterTo$iv$iv;
            ProgressManager.checkCanceled();
            Iterable $this$filter$iv = candidates2;
            boolean $i$f$filter = false;
            sourceClassOrObject = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (KtNamedDeclaration)element$iv$iv;
                boolean bl3 = false;
                if (!MemberMatching.sameReceiverPresenceAndParametersCount(it, declaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            candidates2 = (List)destination$iv$iv;
            if (((List)candidates2).size() <= 1) {
                return (KtNamedDeclaration)CollectionsKt.firstOrNull((List)((List)candidates2));
            }
            if (!this.haveRenamesInImports(SourceNavigationHelperKt.access$getContainingFiles(candidates2))) {
                ProgressManager.checkCanceled();
                $this$filter$iv = candidates2;
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (KtNamedDeclaration)element$iv$iv;
                    boolean bl4 = false;
                    if (!MemberMatching.receiverAndParametersShortTypesMatch(it, declaration)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                candidates2 = (List)destination$iv$iv;
                if (((List)candidates2).size() <= 1) {
                    return (KtNamedDeclaration)CollectionsKt.firstOrNull((List)((List)candidates2));
                }
            }
        }
        for (KtNamedDeclaration candidate : candidates2) {
            CallableDescriptor candidateDescriptor;
            ProgressManager.checkCanceled();
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)candidate, null, 1, null);
            if ((declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null) == null) continue;
            candidateDescriptor = candidateDescriptor;
            if (!(declaration instanceof KtCallableDeclaration) || !ByDescriptorIndexer.INSTANCE.isSameCallable((KtCallableDeclaration)declaration, candidateDescriptor) || ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)declaration) != ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)candidate)) continue;
            return candidate;
        }
        return null;
    }

    private final <T extends KtNamedDeclaration> T findFirstMatchingInIndex(T entity, NavigationKind navigationKind, KotlinStringStubIndexHelper<T> helper2) {
        KtNamedDeclaration ktNamedDeclaration;
        block5: {
            FqName fqName2 = entity.getFqName();
            if (fqName2 == null) {
                return null;
            }
            FqName classFqName = fqName2;
            for (GlobalSearchScope scope : (Iterable)this.targetScopes((KtElement)entity, navigationKind)) {
                KtNamedDeclaration ktNamedDeclaration2;
                KtNamedDeclaration ktNamedDeclaration3;
                Object v3;
                Collection<T> declarations2;
                block4: {
                    boolean bl = false;
                    ProgressManager.checkCanceled();
                    String string = classFqName.asString();
                    Project project = ((PsiElement)entity).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    declarations2 = helper2.get(string, project, scope);
                    Iterable $this$firstOrNull$iv = declarations2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        KtNamedDeclaration declaration = (KtNamedDeclaration)element$iv;
                        boolean bl2 = false;
                        if (!(ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)entity) == ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)declaration))) continue;
                        v3 = element$iv;
                        break block4;
                    }
                    v3 = null;
                }
                if ((ktNamedDeclaration3 = (KtNamedDeclaration)v3) == null) {
                    ktNamedDeclaration3 = (KtNamedDeclaration)CollectionsKt.firstOrNull((Iterable)declarations2);
                }
                if ((ktNamedDeclaration2 = ktNamedDeclaration3) == null) continue;
                ktNamedDeclaration = ktNamedDeclaration2;
                break block5;
            }
            ktNamedDeclaration = null;
        }
        return (T)ktNamedDeclaration;
    }

    private final KtClassOrObject findClassOrObject(KtClassOrObject decompiledClassOrObject, NavigationKind navigationKind) {
        return (KtClassOrObject)this.findFirstMatchingInIndex((KtNamedDeclaration)decompiledClassOrObject, navigationKind, KotlinFullClassNameIndex.Helper);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtNamedDeclaration> getInitialTopLevelCandidates(KtNamedDeclaration declaration, NavigationKind navigationKind) {
        void $this$flatMapTo$iv$iv;
        KotlinStringStubIndexHelper kotlinStringStubIndexHelper;
        List<GlobalSearchScope> scopes = this.targetScopes((KtElement)declaration, navigationKind);
        KtNamedDeclaration ktNamedDeclaration = declaration;
        if (ktNamedDeclaration instanceof KtNamedFunction) {
            kotlinStringStubIndexHelper = KotlinTopLevelFunctionFqnNameIndex.Helper;
        } else if (ktNamedDeclaration instanceof KtProperty) {
            kotlinStringStubIndexHelper = KotlinTopLevelPropertyFqnNameIndex.Helper;
        } else {
            throw new IllegalArgumentException("Neither function nor declaration: " + declaration.getClass().getName());
        }
        KotlinStringStubIndexHelper helper2 = kotlinStringStubIndexHelper;
        Iterable $this$flatMap$iv = scopes;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            GlobalSearchScope scope = (GlobalSearchScope)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            FqName fqName2 = ((KtTypeParameterListOwnerStub)declaration).getFqName();
            Intrinsics.checkNotNull((Object)fqName2);
            String string = fqName2.asString();
            Project project = ((KtTypeParameterListOwnerStub)declaration).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Iterable list$iv$iv = helper2.get(string, project, scope);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<KtNamedDeclaration> getInitialMemberCandidates(KtClassOrObject sourceClassOrObject, Name name2, Class<? extends KtNamedDeclaration> declarationClass) {
        SmartList result2 = new SmartList();
        for (KtDeclaration declaration : sourceClassOrObject.getDeclarations()) {
            if (!declarationClass.isInstance(declaration)) continue;
            KtNamedDeclaration ktNamedDeclaration = declaration instanceof KtNamedDeclaration ? (KtNamedDeclaration)declaration : null;
            if (!Intrinsics.areEqual((Object)name2, (Object)(ktNamedDeclaration != null ? ktNamedDeclaration.getNameAsSafeName() : null))) continue;
            ((Collection)result2).add(declaration);
        }
        return (List)result2;
    }

    @NotNull
    public final KtDeclaration getNavigationElement(@NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.navigateToDeclaration(declaration, NavigationKind.CLASS_FILES_TO_SOURCES);
    }

    @NotNull
    public final KtDeclaration getOriginalElement(@NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return this.navigateToDeclaration(declaration, NavigationKind.SOURCES_TO_CLASS_FILES);
    }

    private final KtDeclaration navigateToDeclaration(KtDeclaration from, NavigationKind navigationKind) {
        KtDeclaration ktDeclaration;
        block11: {
            block10: {
                if (!from.isValid()) break block10;
                Project project = from.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (!DumbService.Companion.isDumb(project)) break block11;
            }
            return from;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[navigationKind.ordinal()]) {
            case 1: {
                if (from.getContainingKtFile().isCompiled()) break;
                return from;
            }
            case 2: {
                PsiFile file = from.getContainingFile();
                if (file instanceof KtFile && ((KtFile)file).isCompiled()) {
                    return from;
                }
                if (!SourceKindFilterUtils.matches(RootKindFilter.librarySources, (PsiElement)from)) {
                    return from;
                }
                if (!KtPsiUtil.isLocal((KtDeclaration)from)) break;
                return from;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if ((ktDeclaration = (KtDeclaration)from.accept((KtVisitor)new SourceAndDecompiledConversionVisitor(navigationKind), (Object)Unit.INSTANCE)) == null) {
            ktDeclaration = from;
        }
        return ktDeclaration;
    }

    private static final GlobalSearchScope targetScopes$lambda$0(BinaryModuleInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return IdeaModuleInfoUtils.getBinariesScope(it);
    }

    private static final GlobalSearchScope targetScopes$lambda$1(LibrarySourceInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return IdeaModuleInfoUtils.getBinariesScope(it.getBinariesModuleInfo());
    }

    static {
        Logger logger = Logger.getInstance(SourceNavigationHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "", "<init>", "(Ljava/lang/String;I)V", "CLASS_FILES_TO_SOURCES", "SOURCES_TO_CLASS_FILES", "kotlin.base.fe10.analysis"})
    public static final class NavigationKind
    extends Enum<NavigationKind> {
        public static final /* enum */ NavigationKind CLASS_FILES_TO_SOURCES = new NavigationKind();
        public static final /* enum */ NavigationKind SOURCES_TO_CLASS_FILES = new NavigationKind();
        private static final /* synthetic */ NavigationKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NavigationKind[] values() {
            return (NavigationKind[])$VALUES.clone();
        }

        public static NavigationKind valueOf(String value) {
            return Enum.valueOf(NavigationKind.class, value);
        }

        @NotNull
        public static EnumEntries<NavigationKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = navigationKindArray = new NavigationKind[]{NavigationKind.CLASS_FILES_TO_SOURCES, NavigationKind.SOURCES_TO_CLASS_FILES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\rJ\u001f\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001f\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u0004\u0018\u00010\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\"J\u001f\u0010#\u001a\u0004\u0018\u00010\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010&J\u001f\u0010'\u001a\u0004\u0018\u00010\t2\u0006\u0010$\u001a\u00020(2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010)R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$SourceAndDecompiledConversionVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "", "navigationKind", "Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;", "<init>", "(Lorg/jetbrains/kotlin/idea/decompiler/navigation/SourceNavigationHelper$NavigationKind;)V", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "data", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitObjectDeclaration", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitTypeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAlias", "(Lorg/jetbrains/kotlin/psi/KtTypeAlias;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtDeclaration;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "kotlin.base.fe10.analysis"})
    private static final class SourceAndDecompiledConversionVisitor
    extends KtVisitor<KtDeclaration, Unit> {
        @NotNull
        private final NavigationKind navigationKind;

        public SourceAndDecompiledConversionVisitor(@NotNull NavigationKind navigationKind) {
            Intrinsics.checkNotNullParameter((Object)((Object)navigationKind), (String)"navigationKind");
            this.navigationKind = navigationKind;
        }

        @Nullable
        public KtNamedDeclaration visitNamedFunction(@NotNull KtNamedFunction function, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction((KtNamedDeclaration)function, this.navigationKind);
        }

        @Nullable
        public KtNamedDeclaration visitProperty(@NotNull KtProperty property, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction((KtNamedDeclaration)property, this.navigationKind);
        }

        @Nullable
        public KtClassOrObject visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.findClassOrObject((KtClassOrObject)declaration, this.navigationKind);
        }

        @Nullable
        public KtClassOrObject visitClass(@NotNull KtClass klass, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.findClassOrObject((KtClassOrObject)klass, this.navigationKind);
        }

        @Nullable
        public KtTypeAlias visitTypeAlias(@NotNull KtTypeAlias typeAlias, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return (KtTypeAlias)INSTANCE.findFirstMatchingInIndex((KtNamedDeclaration)typeAlias, this.navigationKind, KotlinTopLevelTypeAliasFqNameIndex.Helper);
        }

        @Nullable
        public KtDeclaration visitParameter(@NotNull KtParameter parameter, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(KtParameterList.class)};
            KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)CollectionUtilsKt.match((Sequence<? extends Object>)PsiUtilsKt.getParents((PsiElement)((PsiElement)parameter)), kClassArray, Reflection.getOrCreateKotlinClass(KtCallableDeclaration.class));
            if (ktCallableDeclaration == null) {
                throw new IllegalStateException(("Can't typeMatch " + parameter.getParent().getParent()).toString());
            }
            KtCallableDeclaration callableDeclaration = ktCallableDeclaration;
            List list2 = callableDeclaration.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
            List parameters2 = list2;
            int index2 = parameters2.indexOf(parameter);
            Object object = callableDeclaration.accept((KtVisitor)this, (Object)Unit.INSTANCE);
            KtCallableDeclaration ktCallableDeclaration2 = object instanceof KtCallableDeclaration ? (KtCallableDeclaration)object : null;
            if (ktCallableDeclaration2 == null) {
                return null;
            }
            KtCallableDeclaration sourceCallable = ktCallableDeclaration2;
            List list3 = sourceCallable.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getValueParameters(...)");
            List sourceParameters = list3;
            if (sourceParameters.size() != parameters2.size()) {
                return null;
            }
            return (KtDeclaration)sourceParameters.get(index2);
        }

        @Nullable
        public KtNamedDeclaration visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction((KtNamedDeclaration)constructor, this.navigationKind);
        }

        @Nullable
        public KtNamedDeclaration visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor, @NotNull Unit data) {
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return INSTANCE.convertPropertyOrFunction((KtNamedDeclaration)constructor, this.navigationKind);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NavigationKind.values().length];
            try {
                nArray[NavigationKind.CLASS_FILES_TO_SOURCES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NavigationKind.SOURCES_TO_CLASS_FILES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

