/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.LanguageVersionUtilsKt;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.expressions.impl.FirEmptyExpressionBlock;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001&B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ?\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u001aJ-\u0010 \u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\nR\u00020\bj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010!J-\u0010\"\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rR\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0018\u0010#\u001a\u00020\u0018*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0018\u0010%\u001a\u00020\u0018*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010$\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;)V", "reportEmptyThenInExpression", "whenExpression", "reportNotExhaustive", "reportNoElseInWhen", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "subjectClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/KtSourceElement;Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;)V", "isJavaNonAbstractSealed", "", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/name/ClassId;)Z", "missingCases", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "getMissingCases", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;)Ljava/util/List;", "reportElseMisplaced", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;)V", "reportRedundantElse", "isIfExpression", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "isWhenExpression", "AlgebraicTypeKind", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExhaustiveWhenChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExhaustiveWhenChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,165:1\n44#2:166\n52#2:170\n86#2:171\n1786#3,3:167\n37#4:172\n*S KotlinDebug\n*F\n+ 1 FirExhaustiveWhenChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker\n*L\n83#1:166\n108#1:170\n110#1:171\n101#1:167,3\n110#1:172\n*E\n"})
public final class FirExhaustiveWhenChecker
extends FirExpressionChecker<FirWhenExpression> {
    @NotNull
    public static final FirExhaustiveWhenChecker INSTANCE = new FirExhaustiveWhenChecker();

    private FirExhaustiveWhenChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirWhenExpression expression) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.reportNotExhaustive(context2, reporter, expression);
        this.reportElseMisplaced(reporter, context2, expression);
        this.reportRedundantElse(context2, reporter, expression);
    }

    private final void reportEmptyThenInExpression(CheckerContext context2, DiagnosticReporter reporter, FirWhenExpression whenExpression) {
        FirWhenBranch thenBranch;
        KtSourceElement ktSourceElement = whenExpression.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (this.isIfExpression(source) && whenExpression.getUsedAsExpression() && ((thenBranch = (FirWhenBranch)CollectionsKt.firstOrNull(whenExpression.getBranches())) == null || thenBranch.getResult() instanceof FirEmptyExpressionBlock)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINVALID_IF_AS_EXPRESSION(), null, (int)8, null);
        }
    }

    private final void reportNotExhaustive(CheckerContext context2, DiagnosticReporter reporter, FirWhenExpression whenExpression) {
        FirRegularClassSymbol subjectClassSymbol;
        ExhaustivenessStatus exhaustivenessStatus = whenExpression.getExhaustivenessStatus();
        if (exhaustivenessStatus == null) {
            return;
        }
        ExhaustivenessStatus exhaustivenessStatus2 = exhaustivenessStatus;
        if (!(exhaustivenessStatus2 instanceof ExhaustivenessStatus.NotExhaustive)) {
            this.reportEmptyThenInExpression(context2, reporter, whenExpression);
            return;
        }
        KtSourceElement ktSourceElement = whenExpression.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        ConeKotlinType subjectType = ((ExhaustivenessStatus.NotExhaustive)exhaustivenessStatus2).getSubjectType();
        FirRegularClassSymbol firRegularClassSymbol = subjectClassSymbol = subjectType != null ? ToSymbolUtilsKt.toRegularClassSymbol((SessionHolder)context2, subjectType) : null;
        if (whenExpression.getUsedAsExpression()) {
            if (this.isIfExpression(source)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)FirErrors.INSTANCE.getINVALID_IF_AS_EXPRESSION(), null, (int)8, null);
                return;
            }
            if (this.isWhenExpression(source)) {
                this.reportNoElseInWhen(reporter, context2, source, whenExpression, subjectClassSymbol);
            }
        } else {
            AlgebraicTypeKind algebraicTypeKind;
            if (subjectClassSymbol == null) {
                return;
            }
            FirClassLikeSymbol $this$modality$iv = subjectClassSymbol;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() == Modality.SEALED) {
                algebraicTypeKind = AlgebraicTypeKind.Sealed;
            } else if (subjectClassSymbol.getClassKind() == ClassKind.ENUM_CLASS) {
                algebraicTypeKind = AlgebraicTypeKind.Enum;
            } else if (ConeBuiltinTypeUtilsKt.isBooleanOrNullableBoolean(subjectType)) {
                algebraicTypeKind = AlgebraicTypeKind.Boolean;
            } else {
                return;
            }
            AlgebraicTypeKind kind2 = algebraicTypeKind;
            this.reportNoElseInWhen(reporter, context2, source, whenExpression, subjectClassSymbol);
        }
    }

    private final void reportNoElseInWhen(DiagnosticReporter reporter, CheckerContext context2, KtSourceElement source, FirWhenExpression whenExpression, FirRegularClassSymbol subjectClassSymbol) {
        String string;
        Boolean bl;
        boolean bl2;
        List<WhenMissingCase> missingCases;
        block8: {
            missingCases = this.getMissingCases(whenExpression);
            Iterable $this$all$iv = missingCases;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    WhenMissingCase it = (WhenMissingCase)element$iv;
                    boolean bl3 = false;
                    if (it instanceof WhenMissingCase.IsTypeCheckIsMissing && INSTANCE.isJavaNonAbstractSealed(context2, ((WhenMissingCase.IsTypeCheckIsMissing)it).getClassId())) continue;
                    bl2 = false;
                    break block8;
                }
                bl2 = true;
            }
        }
        if (bl2 && !LanguageVersionUtilsKt.isEnabled(context2, LanguageFeature.ProperExhaustivenessCheckForJavaOpenSealedClass)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getMISSING_BRANCH_FOR_NON_ABSTRACT_SEALED_CLASS(), missingCases, null, (int)16, null);
            return;
        }
        FirRegularClassSymbol firRegularClassSymbol = subjectClassSymbol;
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isExpect$iv = firRegularClassSymbol;
            boolean $i$f$isExpect = false;
            bl = $this$isExpect$iv.getRawStatus().isExpect();
        } else {
            bl = null;
        }
        if (Intrinsics.areEqual(bl, (Object)true)) {
            FirClassSymbol $this$isEnumClass$iv = subjectClassSymbol;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            String declarationType = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS ? "enum" : "sealed";
            string = " ('when' with expect " + declarationType + " subject cannot be exhaustive without else branch)";
        } else {
            string = "";
        }
        String description = string;
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), FirErrors.INSTANCE.getNO_ELSE_IN_WHEN(), missingCases, (Object)description, null, (int)32, null);
    }

    private final boolean isJavaNonAbstractSealed(CheckerContext context2, ClassId $this$isJavaNonAbstractSealed) {
        FirClassifierSymbol<?> firClassifierSymbol = ToSymbolUtilsKt.toSymbol((SessionHolder)context2, $this$isJavaNonAbstractSealed);
        FirClassLikeSymbol firClassLikeSymbol = firClassifierSymbol instanceof FirClassLikeSymbol ? (FirClassLikeSymbol)firClassifierSymbol : null;
        if (firClassLikeSymbol == null) {
            return false;
        }
        FirClassLikeSymbol symbol = firClassLikeSymbol;
        FirRegularClassSymbol firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(context2, symbol);
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol fullyExpandedClassSymbol = firRegularClassSymbol;
        return Intrinsics.areEqual((Object)ClassMembersKt.isJavaNonAbstractSealed((FirRegularClass)fullyExpandedClassSymbol.getFir()), (Object)true);
    }

    private final List<WhenMissingCase> getMissingCases(FirWhenExpression $this$missingCases) {
        ExhaustivenessStatus exhaustivenessStatus = $this$missingCases.getExhaustivenessStatus();
        Intrinsics.checkNotNull((Object)exhaustivenessStatus, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus.NotExhaustive");
        return ((ExhaustivenessStatus.NotExhaustive)exhaustivenessStatus).getReasons();
    }

    private final void reportElseMisplaced(DiagnosticReporter reporter, CheckerContext context2, FirWhenExpression expression) {
        int branchesCount = expression.getBranches().size();
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)expression.getBranches())) {
            FirWhenBranch branch = (FirWhenBranch)indexedValue.getValue();
            if (!(branch.getCondition() instanceof FirElseIfTrueCondition) || indexedValue.getIndex() >= branchesCount - 1) continue;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)branch.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getELSE_MISPLACED_IN_WHEN(), null, (int)8, null);
        }
    }

    private final void reportRedundantElse(CheckerContext context2, DiagnosticReporter reporter, FirWhenExpression whenExpression) {
        if (Intrinsics.areEqual((Object)whenExpression.getExhaustivenessStatus(), (Object)ExhaustivenessStatus.RedundantlyExhaustive.INSTANCE)) {
            for (FirWhenBranch branch : whenExpression.getBranches()) {
                if (branch.getSource() == null || !(branch.getCondition() instanceof FirElseIfTrueCondition)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)branch.getSource()), (KtDiagnosticFactory0)FirErrors.INSTANCE.getREDUNDANT_ELSE_IN_WHEN(), null, (int)8, null);
            }
        }
    }

    private final boolean isIfExpression(KtSourceElement $this$isIfExpression) {
        return Intrinsics.areEqual((Object)$this$isIfExpression.getElementType(), (Object)KtNodeTypes.IF);
    }

    private final boolean isWhenExpression(KtSourceElement $this$isWhenExpression) {
        return Intrinsics.areEqual((Object)$this$isWhenExpression.getElementType(), (Object)KtNodeTypes.WHEN);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker$AlgebraicTypeKind;", "", "displayName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getDisplayName", "()Ljava/lang/String;", "Sealed", "Enum", "Boolean", "checkers"})
    private static final class AlgebraicTypeKind
    extends Enum<AlgebraicTypeKind> {
        @NotNull
        private final String displayName;
        public static final /* enum */ AlgebraicTypeKind Sealed = new AlgebraicTypeKind("sealed class/interface");
        public static final /* enum */ AlgebraicTypeKind Enum = new AlgebraicTypeKind("enum");
        public static final /* enum */ AlgebraicTypeKind Boolean = new AlgebraicTypeKind("Boolean");
        private static final /* synthetic */ AlgebraicTypeKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AlgebraicTypeKind(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static AlgebraicTypeKind[] values() {
            return (AlgebraicTypeKind[])$VALUES.clone();
        }

        public static AlgebraicTypeKind valueOf(String value) {
            return java.lang.Enum.valueOf(AlgebraicTypeKind.class, value);
        }

        @NotNull
        public static EnumEntries<AlgebraicTypeKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = algebraicTypeKindArray = new AlgebraicTypeKind[]{AlgebraicTypeKind.Sealed, AlgebraicTypeKind.Enum, AlgebraicTypeKind.Boolean};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

