/*! @azure/msal-browser v4.28.2 2026-02-10 */
'use strict';
import { AuthFlowStateBase } from '../../../core/auth_flow/AuthFlowState.mjs';
import { GET_ACCESS_TOKEN_COMPLETED_STATE_TYPE, GET_ACCESS_TOKEN_FAILED_STATE_TYPE } from '../../../core/auth_flow/AuthFlowStateTypes.mjs';

/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */
/**
 * The completed state of the get access token flow.
 */
class GetAccessTokenCompletedState extends AuthFlowStateBase {
    constructor() {
        super(...arguments);
        /**
         * The type of the state.
         */
        this.stateType = GET_ACCESS_TOKEN_COMPLETED_STATE_TYPE;
    }
}
/**
 * The failed state of the get access token flow.
 */
class GetAccessTokenFailedState extends AuthFlowStateBase {
    constructor() {
        super(...arguments);
        /**
         * The type of the state.
         */
        this.stateType = GET_ACCESS_TOKEN_FAILED_STATE_TYPE;
    }
}

export { GetAccessTokenCompletedState, GetAccessTokenFailedState };
//# sourceMappingURL=GetAccessTokenState.mjs.map
